/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.sequence.validation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.sequence.part.Messages;
import org.eclipse.papyrus.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.diagram.sequence.validation.FragmentOrderingKeeper;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;

public class UMLValidationHelper {
    public static IStatus validateFragmentsOrder(EObject context, IValidationContext ctx) {
        if (context instanceof View) {
            return UMLValidationHelper.validateFragmentsOrder(((View)context).getElement(), ctx);
        }
        if (context instanceof Bounds) {
            return UMLValidationHelper.validateFragmentsOrder(((Bounds)context).eContainer(), ctx);
        }
        if (context instanceof Interaction) {
            return UMLValidationHelper.validateFragmentsOrder((Interaction)context, ctx);
        }
        if (context instanceof InteractionOperand) {
            return UMLValidationHelper.validateFragmentsOrder((InteractionOperand)context, ctx);
        }
        if (context instanceof InteractionFragment) {
            return UMLValidationHelper.validateFragmentsOrder((EObject)((InteractionFragment)context).getOwner(), ctx);
        }
        if (context instanceof Message) {
            EObject sendFragmentContainer = ((Message)context).getSendEvent().eContainer();
            EObject receiveFragmentContainer = ((Message)context).getReceiveEvent().eContainer();
            if (sendFragmentContainer != null) {
                return UMLValidationHelper.validateFragmentsOrder(sendFragmentContainer, ctx);
            }
            if (receiveFragmentContainer != null) {
                return UMLValidationHelper.validateFragmentsOrder(receiveFragmentContainer, ctx);
            }
        } else if (context instanceof Lifeline) {
            return UMLValidationHelper.validateFragmentsOrder(((Lifeline)context).getInteraction(), ctx);
        }
        return ctx.createSuccessStatus();
    }

    public static IStatus validateFragmentsOrder(Interaction context, IValidationContext ctx) {
        try {
            FragmentOrderingKeeper keeper = new FragmentOrderingKeeper();
            return keeper.validate((EObject)context, ctx);
        }
        catch (Exception e) {
            UMLDiagramEditorPlugin.getInstance().logError(Messages.FragmentOrderingKeeper_error, e);
            return ctx.createSuccessStatus();
        }
    }

    public static IStatus validateFragmentsOrder(InteractionOperand context, IValidationContext ctx) {
        try {
            FragmentOrderingKeeper keeper = new FragmentOrderingKeeper();
            return keeper.validate((EObject)context, ctx);
        }
        catch (Exception e) {
            UMLDiagramEditorPlugin.getInstance().logError(Messages.FragmentOrderingKeeper_error, e);
            return ctx.createSuccessStatus();
        }
    }
}

