/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.statemachine.custom.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.diagram.statemachine.custom.helpers.Zone;
import org.eclipse.papyrus.diagram.statemachine.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.diagram.statemachine.providers.ElementInitializers;
import org.eclipse.papyrus.diagram.statemachine.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.UMLFactory;

public class CustomFirstRegionInCompositeStateCreateElementCommand
extends AbstractTransactionalCommand {
    IAdaptable adaptable;
    IAdaptable adaptableForDropped = null;
    PreferencesHint prefHints;
    CreateViewRequest.ViewDescriptor viewDescriptor;
    CreateElementRequest createElementRequest;
    String dropLocation = "";

    public CustomFirstRegionInCompositeStateCreateElementCommand(IAdaptable adaptable, IAdaptable adaptableForDropped, PreferencesHint prefHints, TransactionalEditingDomain domain, String label, String dropLocation) {
        super(domain, label, null);
        this.adaptable = adaptable;
        this.adaptableForDropped = adaptableForDropped;
        this.prefHints = prefHints;
        this.viewDescriptor = new CreateViewRequest.ViewDescriptor(adaptable, prefHints);
        this.setResult(CommandResult.newOKCommandResult((Object)this.viewDescriptor));
        this.dropLocation = dropLocation;
    }

    public boolean canExecute() {
        View compartment = (View)this.adaptable.getAdapter(View.class);
        if (compartment.getChildren().isEmpty()) {
            View owner = (View)compartment.eContainer();
            State state = (State)owner.getElement();
            return state.getSubmachine() == null;
        }
        return false;
    }

    protected void doConfigure(Region newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = this.createElementRequest.getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(this.createElementRequest.getClientContext());
        configureRequest.addParameters(this.createElementRequest.getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View compartment = (View)this.adaptable.getAdapter(View.class);
        View ownerView = (View)compartment.eContainer();
        int height = Zone.getHeight(ownerView);
        int width = Zone.getWidth(ownerView);
        if (height < 100) {
            height = 100;
            Zone.setHeight(ownerView, height);
        }
        if (width < 200) {
            width = 200;
            Zone.setWidth(ownerView, width);
        }
        if (this.adaptableForDropped == null) {
            Region umlRegion = UMLFactory.eINSTANCE.createRegion();
            this.createElementRequest = new CreateElementRequest(this.getEditingDomain(), (EObject)ownerView, UMLElementTypes.Region_3000);
            State umlState = (State)ownerView.getElement();
            umlState.getRegions().add((Object)umlRegion);
            ElementInitializers.getInstance().init_Region_3000(umlRegion);
            this.doConfigure(umlRegion, monitor, info);
            this.adaptableForDropped = new SemanticAdapter((EObject)umlRegion, null);
        }
        String semanticHint = ((IHintedType)UMLElementTypes.Region_3000).getSemanticHint();
        Node newRegion = ViewService.getInstance().createNode(this.adaptableForDropped, compartment, semanticHint, -1, this.prefHints);
        Zone.createRegionDefaultAnnotation((View)newRegion);
        for (Node currentNode : ownerView.getChildren()) {
            if (currentNode.getLayoutConstraint() == null) {
                currentNode.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
            }
            if (UMLVisualIDRegistry.getVisualID(currentNode.getType()) == 6001) {
                Zone.setWidth((View)currentNode, width);
                Zone.setHeight((View)currentNode, 13);
                continue;
            }
            if (UMLVisualIDRegistry.getVisualID(currentNode.getType()) != 6002) continue;
            Zone.setY((View)currentNode, 13);
            Zone.setWidth((View)currentNode, width);
            Zone.setHeight((View)currentNode, height - 13);
            for (Node subCurrentNode : currentNode.getChildren()) {
                if (subCurrentNode.getLayoutConstraint() == null) {
                    subCurrentNode.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
                }
                if (UMLVisualIDRegistry.getVisualID(subCurrentNode.getType()) != 3000) continue;
                Zone.setWidth((View)subCurrentNode, width);
                Zone.setHeight((View)subCurrentNode, height - 13);
            }
        }
        this.viewDescriptor.setView((View)newRegion);
        return CommandResult.newOKCommandResult((Object)this.viewDescriptor);
    }
}

