/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.statemachine.custom.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.diagram.statemachine.custom.helpers.Zone;
import org.eclipse.papyrus.diagram.statemachine.providers.ElementInitializers;
import org.eclipse.papyrus.diagram.statemachine.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.UMLFactory;

public class CustomRegionCreateElementCommand
extends AbstractTransactionalCommand {
    IAdaptable adaptable;
    IAdaptable adaptableForDropped = null;
    PreferencesHint prefHints;
    CreateViewRequest.ViewDescriptor viewDescriptor;
    CreateElementRequest createElementRequest;
    String dropLocation = "R";

    public CustomRegionCreateElementCommand(IAdaptable adaptable, IAdaptable adaptableForDropped, PreferencesHint prefHints, TransactionalEditingDomain domain, String label, String dropLocation) {
        super(domain, label, null);
        this.adaptable = adaptable;
        this.adaptableForDropped = adaptableForDropped;
        this.prefHints = prefHints;
        this.viewDescriptor = new CreateViewRequest.ViewDescriptor(adaptable, prefHints);
        this.setResult(CommandResult.newOKCommandResult((Object)this.viewDescriptor));
        this.dropLocation = dropLocation;
    }

    protected void doConfigure(Region newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = this.createElementRequest.getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(this.createElementRequest.getClientContext());
        configureRequest.addParameters(this.createElementRequest.getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View existingRegion = (View)this.adaptable.getAdapter(View.class);
        int height = Zone.getHeight(existingRegion);
        int width = Zone.getWidth(existingRegion);
        int x = Zone.getX(existingRegion);
        int y = Zone.getY(existingRegion);
        View compartment = (View)existingRegion.eContainer();
        View ownerView = (View)compartment.eContainer();
        if (this.adaptableForDropped == null) {
            Region umlRegion = UMLFactory.eINSTANCE.createRegion();
            this.createElementRequest = new CreateElementRequest(this.getEditingDomain(), (EObject)ownerView, UMLElementTypes.Region_3000);
            if (ownerView.getElement() instanceof StateMachine) {
                StateMachine umlStateMachine = (StateMachine)ownerView.getElement();
                umlStateMachine.getRegions().add((Object)umlRegion);
            } else if (ownerView.getElement() instanceof State) {
                State umlState = (State)ownerView.getElement();
                umlState.getRegions().add((Object)umlRegion);
            }
            ElementInitializers.getInstance().init_Region_3000(umlRegion);
            this.doConfigure(umlRegion, monitor, info);
            this.adaptableForDropped = new SemanticAdapter((EObject)umlRegion, null);
        }
        String semanticHint = ((IHintedType)UMLElementTypes.Region_3000).getSemanticHint();
        Node newRegion = ViewService.getInstance().createNode(this.adaptableForDropped, compartment, semanticHint, -1, this.prefHints);
        Zone.createRegionDefaultAnnotation((View)newRegion);
        if (Zone.isRight(this.dropLocation)) {
            Zone.copyZone(existingRegion, (View)newRegion);
            Zone.setRight((View)newRegion);
            Zone.setLeft(existingRegion);
            width = (int)((double)width * 0.5);
            Zone.setWidth(existingRegion, width);
            Zone.setWidth((View)newRegion, width);
            Zone.setHeight((View)newRegion, height);
            Zone.setX((View)newRegion, x + width);
            Zone.setY((View)newRegion, y);
        } else if (Zone.isLeft(this.dropLocation)) {
            Zone.copyZone(existingRegion, (View)newRegion);
            Zone.setLeft((View)newRegion);
            Zone.setRight(existingRegion);
            width = (int)((double)width * 0.5);
            Zone.setWidth(existingRegion, width);
            Zone.setWidth((View)newRegion, width);
            Zone.setHeight((View)newRegion, height);
            Zone.setX(existingRegion, x + width);
            Zone.setX((View)newRegion, x);
            Zone.setY((View)newRegion, y);
        } else if (Zone.isBottom(this.dropLocation)) {
            Zone.copyZone(existingRegion, (View)newRegion);
            Zone.setBottom((View)newRegion);
            Zone.setTop(existingRegion);
            height = (int)((double)height * 0.5);
            Zone.setHeight(existingRegion, height);
            Zone.setWidth((View)newRegion, width);
            Zone.setHeight((View)newRegion, height);
            Zone.setX((View)newRegion, x);
            Zone.setY((View)newRegion, y + height);
        } else if (Zone.isTop(this.dropLocation)) {
            Zone.copyZone(existingRegion, (View)newRegion);
            Zone.setTop((View)newRegion);
            Zone.setBottom(existingRegion);
            height = (int)((double)height * 0.5);
            Zone.setHeight(existingRegion, height);
            Zone.setWidth((View)newRegion, width);
            Zone.setHeight((View)newRegion, height);
            Zone.setY(existingRegion, y + height);
            Zone.setX((View)newRegion, x);
            Zone.setY((View)newRegion, y);
        }
        this.viewDescriptor.setView((View)newRegion);
        return CommandResult.newOKCommandResult((Object)this.viewDescriptor);
    }
}

