/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.statemachine.custom.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.statemachine.custom.helpers.Zone;

public class CustomRegionMoveCommand
extends AbstractTransactionalCommand {
    IAdaptable adaptableForTargetRegion;
    IAdaptable adaptableForRegionToMove;
    String dropLocation = "R";
    PreferencesHint prefHints;
    CreateViewRequest.ViewDescriptor viewDescriptor;

    public CustomRegionMoveCommand(IAdaptable adaptableForTargetRegion, IAdaptable adaptableForRegionToMove, PreferencesHint prefHints, TransactionalEditingDomain domain, String label, String dropLocation) {
        super(domain, label, null);
        this.adaptableForTargetRegion = adaptableForTargetRegion;
        this.adaptableForRegionToMove = adaptableForRegionToMove;
        this.prefHints = prefHints;
        this.viewDescriptor = new CreateViewRequest.ViewDescriptor(adaptableForRegionToMove, prefHints);
        this.setResult(CommandResult.newOKCommandResult((Object)this.viewDescriptor));
        this.dropLocation = dropLocation;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        View targetRegion = (View)this.adaptableForTargetRegion.getAdapter(View.class);
        View regionToMove = (View)this.adaptableForRegionToMove.getAdapter(View.class);
        View compartment = (View)regionToMove.eContainer();
        if (compartment.getChildren().size() != 1) {
            int regionWidth = Zone.getWidth(regionToMove);
            int regionHeight = Zone.getHeight(regionToMove);
            String s = Zone.getZone(regionToMove);
            List<View> neighbours = null;
            if (Zone.isRight(s)) {
                neighbours = Zone.getRegionLeftBorderOutsideNeighbours(regionToMove);
                for (View view : neighbours) {
                    int width = Zone.getWidth(view);
                    Zone.setWidth(view, width += regionWidth);
                }
            } else if (Zone.isLeft(s)) {
                neighbours = Zone.getRegionRightBorderOutsideNeighbours(regionToMove);
                for (View view : neighbours) {
                    int width = Zone.getWidth(view);
                    Zone.setWidth(view, width += regionWidth);
                    int x = Zone.getX(view);
                    Zone.setX(view, x -= regionWidth);
                }
            } else if (Zone.isTop(s)) {
                neighbours = Zone.getRegionBottomBorderOutsideNeighbours(regionToMove);
                for (View view : neighbours) {
                    int height = Zone.getHeight(view);
                    Zone.setHeight(view, height += regionHeight);
                    int y = Zone.getY(view);
                    Zone.setY(view, y -= regionHeight);
                }
            } else if (Zone.isBottom(s)) {
                neighbours = Zone.getRegionTopBorderOutsideNeighbours(regionToMove);
                for (View view : neighbours) {
                    int height = Zone.getHeight(view);
                    Zone.setHeight(view, height += regionHeight);
                }
            }
            Zone.resetRegionCounterpartZone(regionToMove);
        }
        int height = Zone.getHeight(targetRegion);
        int width = Zone.getWidth(targetRegion);
        int x = Zone.getX(targetRegion);
        int y = Zone.getY(targetRegion);
        if (Zone.isRight(this.dropLocation)) {
            Zone.copyZone(targetRegion, regionToMove);
            Zone.setRight(regionToMove);
            Zone.setLeft(targetRegion);
            width = (int)((double)width * 0.5);
            Zone.setWidth(targetRegion, width);
            Zone.setWidth(regionToMove, width);
            Zone.setHeight(regionToMove, height);
            Zone.setX(regionToMove, x + width);
            Zone.setY(regionToMove, y);
        } else if (Zone.isLeft(this.dropLocation)) {
            Zone.copyZone(targetRegion, regionToMove);
            Zone.setLeft(regionToMove);
            Zone.setRight(targetRegion);
            width = (int)((double)width * 0.5);
            Zone.setWidth(targetRegion, width);
            Zone.setWidth(regionToMove, width);
            Zone.setHeight(regionToMove, height);
            Zone.setX(targetRegion, x + width);
            Zone.setX(regionToMove, x);
            Zone.setY(regionToMove, y);
        } else if (Zone.isBottom(this.dropLocation)) {
            Zone.copyZone(targetRegion, regionToMove);
            Zone.setBottom(regionToMove);
            Zone.setTop(targetRegion);
            height = (int)((double)height * 0.5);
            Zone.setHeight(targetRegion, height);
            Zone.setWidth(regionToMove, width);
            Zone.setHeight(regionToMove, height);
            Zone.setX(regionToMove, x);
            Zone.setY(regionToMove, y + height);
        } else if (Zone.isTop(this.dropLocation)) {
            Zone.copyZone(targetRegion, regionToMove);
            Zone.setTop(regionToMove);
            Zone.setBottom(targetRegion);
            height = (int)((double)height * 0.5);
            Zone.setHeight(targetRegion, height);
            Zone.setWidth(regionToMove, width);
            Zone.setHeight(regionToMove, height);
            Zone.setY(targetRegion, y + height);
            Zone.setX(regionToMove, x);
            Zone.setY(regionToMove, y);
        }
        this.viewDescriptor.setView(regionToMove);
        return CommandResult.newOKCommandResult();
    }
}

