/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.statemachine.custom.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.statemachine.custom.helpers.Zone;

public class CustomRegionResizeCommand
extends AbstractTransactionalCommand {
    CreateViewRequest.ViewDescriptor viewDescriptor;
    IAdaptable adaptable;
    PreferencesHint prefHints;
    private ChangeBoundsRequest request = null;
    private Rectangle bounds = null;

    public CustomRegionResizeCommand(IAdaptable adaptable, PreferencesHint prefHints, TransactionalEditingDomain domain, String label, ChangeBoundsRequest request, Rectangle bounds) {
        super(domain, label, null);
        this.adaptable = adaptable;
        this.prefHints = prefHints;
        this.request = request;
        this.bounds = bounds;
        this.viewDescriptor = new CreateViewRequest.ViewDescriptor(adaptable, prefHints);
        this.setResult(CommandResult.newOKCommandResult((Object)this.viewDescriptor));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View region = (View)this.adaptable.getAdapter(View.class);
        int direction = this.request.getResizeDirection();
        int dx = this.request.getSizeDelta().width;
        int dy = this.request.getSizeDelta().height;
        switch (direction) {
            case 8: {
                int width;
                List<View> todo = Zone.getRegionLeftBorderOutsideNeighbours(region);
                for (View view : todo) {
                    width = Zone.getWidth(view);
                    Zone.setWidth(view, width -= dx);
                }
                todo = Zone.getRegionLeftBorderInsideNeighbours(region);
                for (View view : todo) {
                    width = Zone.getWidth(view);
                    Zone.setWidth(view, width += dx);
                    int x = Zone.getX(view);
                    Zone.setX(view, x -= dx);
                }
                break;
            }
            case 16: {
                int width;
                List<View> todo = Zone.getRegionRightBorderInsideNeighbours(region);
                for (View view : todo) {
                    width = Zone.getWidth(view);
                    Zone.setWidth(view, width += dx);
                }
                todo = Zone.getRegionRightBorderOutsideNeighbours(region);
                for (View view : todo) {
                    width = Zone.getWidth(view);
                    Zone.setWidth(view, width -= dx);
                    int x = Zone.getX(view);
                    Zone.setX(view, x += dx);
                }
                break;
            }
            case 1: {
                int height;
                List<View> todo = Zone.getRegionTopBorderInsideNeighbours(region);
                for (View view : todo) {
                    height = Zone.getHeight(view);
                    Zone.setHeight(view, height += dy);
                    int y = Zone.getY(view);
                    Zone.setY(view, y -= dy);
                }
                todo = Zone.getRegionTopBorderOutsideNeighbours(region);
                for (View view : todo) {
                    height = Zone.getHeight(view);
                    Zone.setHeight(view, height -= dy);
                }
                break;
            }
            case 4: {
                int height;
                List<View> todo = Zone.getRegionBottomBorderInsideNeighbours(region);
                for (View view : todo) {
                    height = Zone.getHeight(view);
                    Zone.setHeight(view, height += dy);
                }
                todo = Zone.getRegionBottomBorderOutsideNeighbours(region);
                for (View view : todo) {
                    height = Zone.getHeight(view);
                    Zone.setHeight(view, height -= dy);
                    int y = Zone.getY(view);
                    Zone.setY(view, y += dy);
                }
                break;
            }
        }
        return CommandResult.newOKCommandResult();
    }

    public void reverseRequest() {
        this.request.getMoveDelta().negate();
    }
}

