/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.statemachine.custom.edit.part;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.statemachine.custom.figures.RegionFigure;
import org.eclipse.papyrus.diagram.statemachine.custom.helpers.Zone;
import org.eclipse.papyrus.diagram.statemachine.custom.policies.CustomRegionDragTracker;
import org.eclipse.papyrus.diagram.statemachine.custom.policies.CustomRegionResizableEditPolicy;
import org.eclipse.papyrus.diagram.statemachine.edit.parts.RegionEditPart;

public class CustomRegionEditPart
extends RegionEditPart {
    private DragTracker tracker = null;

    public CustomRegionEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.removeEditPolicy("ConnectionHandlesPolicy");
        this.removeEditPolicy("PopupBarEditPolicy");
    }

    public DragTracker getDragTracker(Request request) {
        this.tracker = new CustomRegionDragTracker(this);
        return this.tracker;
    }

    public CustomRegionDragTracker getRegionDragTracker() {
        if (this.tracker != null && this.tracker instanceof CustomRegionDragTracker) {
            return (CustomRegionDragTracker)this.tracker;
        }
        return null;
    }

    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        if (this.getParent() != null) {
            this.refreshVisuals();
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        View view = (View)this.getModel();
        RegionFigure f = this.getPrimaryShape();
        String zone = Zone.getZone(view);
        if (Zone.hasRightNeighbours(zone)) {
            f.setDisplayRightBorder(true);
        } else {
            f.setDisplayRightBorder(false);
        }
        if (Zone.hasBottomNeighbours(zone)) {
            f.setDisplayBottomBorder(true);
        } else {
            f.setDisplayBottomBorder(false);
        }
        CustomRegionResizableEditPolicy policy = (CustomRegionResizableEditPolicy)this.getEditPolicy("PrimaryDrag Policy");
        int dirs = Zone.getAllowedResizeDirections(zone);
        if (policy != null) {
            policy.setResizeDirections(dirs);
        }
    }
}

