/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.statemachine.custom.edit.part;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.diagram.common.figure.node.StereotypePropertiesCompartment;
import org.eclipse.papyrus.diagram.statemachine.custom.commands.CustomStateResizeCommand;
import org.eclipse.papyrus.diagram.statemachine.custom.figures.StateFigure;
import org.eclipse.papyrus.diagram.statemachine.custom.helpers.Zone;
import org.eclipse.papyrus.diagram.statemachine.edit.parts.StateEditPart;
import org.eclipse.papyrus.diagram.statemachine.edit.parts.StateNameEditPart;
import org.eclipse.uml2.uml.State;

public class CustomStateNameEditPart
extends StateNameEditPart {
    public CustomStateNameEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.removeEditPolicy("ConnectionHandlesPolicy");
        this.removeEditPolicy("PopupBarEditPolicy");
    }

    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        this.refreshVisuals();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        StateFigure stateFigure = ((StateEditPart)this.getParent()).getPrimaryShape();
        State state = (State)((View)this.getModel()).getElement();
        View stateLabelView = (View)this.getModel();
        View stateView = (View)stateLabelView.eContainer();
        View stateCompartView = (View)stateView.getChildren().get(1);
        if (stateCompartView.getChildren().isEmpty()) {
            stateFigure.getStateCompartmentFigure().setVisible(false);
        } else {
            stateFigure.getStateCompartmentFigure().setVisible(true);
        }
        if (state.isSubmachineState()) {
            stateFigure.setSubmachineStateName(String.valueOf(state.getName()) + " : " + state.getSubmachine().getQualifiedName());
            stateFigure.setIsSubmachineState(true);
        } else {
            stateFigure.setIsSubmachineState(false);
        }
        int height = 0;
        int width = 0;
        for (IFigure current : this.getFigure().getParent().getChildren()) {
            if (!(current instanceof Label) && !(current instanceof WrappingLabel) && !(current instanceof StereotypePropertiesCompartment)) continue;
            Dimension d = current.getPreferredSize().getCopy();
            height += d.height;
            width = Math.max(width, d.width);
        }
        int stateHeight = Zone.getHeight(stateView);
        int stateWidth = Zone.getWidth(stateView);
        int stateCompartHeight = Zone.getHeight(stateCompartView);
        int dx = (width += 10) - stateWidth;
        int dy = stateCompartHeight + height - stateHeight;
        int x = Zone.getX(stateView);
        int y = Zone.getY(stateView);
        if (stateHeight != -1 && width != 0 && dy != 0) {
            dx = dx > 0 ? dx : 0;
            SemanticAdapter adaptableForState = new SemanticAdapter(null, (Object)stateView);
            ChangeBoundsRequest internalResizeRequest = new ChangeBoundsRequest();
            internalResizeRequest.setResizeDirection(16);
            internalResizeRequest.setSizeDelta(new Dimension(dx, dy));
            Rectangle rect = new Rectangle(x, y, stateWidth + dx, stateHeight + dy);
            CustomStateResizeCommand internalResizeCommand = new CustomStateResizeCommand((IAdaptable)adaptableForState, this.getDiagramPreferencesHint(), this.getEditingDomain(), DiagramUIMessages.CreateCommand_Label, internalResizeRequest, rect, true);
            internalResizeCommand.setOptions(Collections.singletonMap("unprotected", Boolean.TRUE));
            try {
                internalResizeCommand.execute(null, null);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }
}

