/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.statemachine.custom.parsers;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.diagram.statemachine.custom.parsers.SemanticElementsToParseGetter;
import org.eclipse.papyrus.diagram.statemachine.custom.parsers.TriggerTextGetter;
import org.eclipse.papyrus.umlutils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLFactory;

public class TransitionPropertiesParser
implements IParser,
ISemanticParser {
    private static final String ONE_SPACE_STRING = " ";
    protected Constraint guardConstraint = null;
    private static String EMPTY_STRING = "";

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public String getEditString(IAdaptable element, int flags) {
        if (element instanceof EObjectAdapter) {
            Transition transition = (Transition)((EObjectAdapter)element).getRealObject();
        }
        return EMPTY_STRING;
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        final Transition transition = (Transition)((EObjectAdapter)element).getRealObject();
        final String result = newString;
        AbstractTransactionalCommand tc = new AbstractTransactionalCommand(EditorUtils.getTransactionalEditingDomain(), "Edit Transition Properties", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        RecordingCommand rc = new RecordingCommand(EditorUtils.getTransactionalEditingDomain()){

                            protected void doExecute() {
                                EList elements = transition.getModel().allOwnedElements();
                                for (Element pElement : elements) {
                                    if (!(pElement instanceof Constraint) || !result.equals(((NamedElement)pElement).getName())) continue;
                                    ((this).this).TransitionPropertiesParser.this.guardConstraint = (Constraint)pElement;
                                    transition.setGuard(((this).this).TransitionPropertiesParser.this.guardConstraint);
                                }
                                if (((this).this).TransitionPropertiesParser.this.guardConstraint == null) {
                                    ((this).this).TransitionPropertiesParser.this.guardConstraint = UMLFactory.eINSTANCE.createConstraint();
                                    ((this).this).TransitionPropertiesParser.this.guardConstraint.setName(result);
                                    ((this).this).TransitionPropertiesParser.this.guardConstraint.setContext(transition.getNamespace());
                                    transition.setGuard(((this).this).TransitionPropertiesParser.this.guardConstraint);
                                }
                            }
                        };
                        EditorUtils.getTransactionalEditingDomain().getCommandStack().execute((Command)rc);
                    }
                });
                return CommandResult.newOKCommandResult();
            }
        };
        return tc;
    }

    public String getPrintString(IAdaptable element, int flags) {
        String label = this.getValueString(element, flags);
        if (label == null || label.length() == 0) {
            label = ONE_SPACE_STRING;
        }
        return label;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        int notificationType;
        if (event instanceof Notification && 1 == (notificationType = ((Notification)event).getEventType())) {
            if (((Notification)event).getNewValue() instanceof Constraint) {
                this.guardConstraint = (Constraint)((Notification)event).getNewValue();
            }
            return true;
        }
        return false;
    }

    protected String getValueString(IAdaptable element, int flags) {
        Object obj = element.getAdapter(EObject.class);
        if (obj instanceof Transition) {
            Transition trans = (Transition)obj;
            StringBuilder result = new StringBuilder();
            String textForTrigger = this.getTextForTrigger(trans);
            if (textForTrigger != null && !EMPTY_STRING.equals(textForTrigger)) {
                result.append(textForTrigger).append(ONE_SPACE_STRING);
            }
            result.append(this.getTextForGuard(trans));
            String textForEffect = this.getTextForEffect(trans);
            if (textForEffect != null && !EMPTY_STRING.equals(textForEffect)) {
                result.append("/ ").append(textForEffect);
            }
            return result.toString();
        }
        return EMPTY_STRING;
    }

    protected String getTextForGuard(Transition trans) {
        String value;
        Constraint valueSpec = trans.getGuard();
        if (valueSpec != null && (value = ValueSpecificationUtil.getConstraintnValue((Constraint)valueSpec)) != null) {
            return String.format("[%s]", value);
        }
        return EMPTY_STRING;
    }

    protected String getTextForEffect(Transition trans) {
        StringBuilder text = new StringBuilder();
        String result = EMPTY_STRING;
        Behavior effect = trans.getEffect();
        if (effect != null) {
            if (effect instanceof OpaqueBehavior) {
                result = (String)((OpaqueBehavior)effect).getBodies().get(0);
            } else {
                EClass eClass = effect.eClass();
                if (eClass != null) {
                    text.append(eClass.getName()).append(" :").append(effect.getName());
                    result = String.format("%s", text.toString());
                }
            }
        }
        return result;
    }

    protected String getTextForTrigger(Transition trans) {
        StringBuilder result = new StringBuilder();
        boolean isFirstTrigger = true;
        TriggerTextGetter triggerTextGetter = new TriggerTextGetter();
        for (Trigger t : trans.getTriggers()) {
            Event e;
            String tText;
            if (t == null || t.getEvent() == null || (tText = (String)triggerTextGetter.doSwitch((EObject)(e = t.getEvent()))) == null || tText.equals("")) continue;
            if (!isFirstTrigger) {
                result.append(", ");
            } else {
                isFirstTrigger = false;
            }
            result.append(tText);
        }
        return result.toString();
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return new ParserEditStatus("org.eclipse.papyrus.diagram.statemachine", 0, "");
    }

    public List getSemanticElementsBeingParsed(EObject element) {
        SemanticElementsToParseGetter getter = new SemanticElementsToParseGetter();
        return (List)getter.doSwitch(element);
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return true;
    }
}

