/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.statemachine.custom.parsers;

import org.eclipse.papyrus.umlutils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.AnyReceiveEvent;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.CreationEvent;
import org.eclipse.uml2.uml.DestructionEvent;
import org.eclipse.uml2.uml.ExecutionEvent;
import org.eclipse.uml2.uml.ReceiveOperationEvent;
import org.eclipse.uml2.uml.ReceiveSignalEvent;
import org.eclipse.uml2.uml.SendOperationEvent;
import org.eclipse.uml2.uml.SendSignalEvent;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerTextGetter
extends UMLSwitch<String> {
    public String caseAnyReceiveEvent(AnyReceiveEvent object) {
        return "all";
    }

    public String caseChangeEvent(ChangeEvent object) {
        StringBuilder result = new StringBuilder();
        ValueSpecification spec = object.getChangeExpression();
        if (spec != null) {
            result.append("When \"");
            result.append(spec.getName());
            result.append(" = ");
            String specText = ValueSpecificationUtil.getSpecificationValue((ValueSpecification)spec);
            result.append(specText);
            if (spec.getType() != null) {
                result.append(" ");
                result.append(spec.getType().getName());
            }
            result.append("\"");
        } else {
            result.append(object.getName());
        }
        return result.toString();
    }

    public String caseTimeEvent(TimeEvent object) {
        StringBuilder result = new StringBuilder();
        TimeExpression spec = object.getWhen();
        if (spec != null) {
            if (object.isRelative()) {
                result.append("After \"");
            } else {
                result.append("At \"");
            }
            result.append(spec.getName());
            result.append(" = ");
            String specText = ValueSpecificationUtil.getSpecificationValue((ValueSpecification)spec);
            result.append(specText);
            if (spec.getType() != null) {
                result.append(" ");
                result.append(spec.getType().getName());
            }
            result.append("\"");
        } else {
            result.append(object.getName());
        }
        return result.toString();
    }

    public String caseCreationEvent(CreationEvent object) {
        return object.getName();
    }

    public String caseDestructionEvent(DestructionEvent object) {
        return object.getName();
    }

    public String caseExecutionEvent(ExecutionEvent object) {
        return object.getName();
    }

    public String caseCallEvent(CallEvent object) {
        StringBuilder result = new StringBuilder();
        if (object.getOperation() != null) {
            String operation = object.getOperation().getName();
            result.append(operation);
        } else {
            result.append(object.getName());
        }
        return result.toString();
    }

    public String caseReceiveOperationEvent(ReceiveOperationEvent object) {
        StringBuilder result = new StringBuilder();
        if (object.getOperation() != null) {
            String operation = object.getOperation().getName();
            result.append(operation);
        } else {
            result.append(object.getName());
        }
        return result.toString();
    }

    public String caseSendOperationEvent(SendOperationEvent object) {
        StringBuilder result = new StringBuilder();
        if (object.getOperation() != null) {
            String operation = object.getOperation().getName();
            result.append(operation);
        } else {
            result.append(object.getName());
        }
        return result.toString();
    }

    public String caseReceiveSignalEvent(ReceiveSignalEvent object) {
        StringBuilder result = new StringBuilder();
        if (object.getSignal() != null) {
            String signal = object.getSignal().getName();
            result.append(signal);
        } else {
            result.append(object.getName());
        }
        return result.toString();
    }

    public String caseSendSignalEvent(SendSignalEvent object) {
        StringBuilder result = new StringBuilder();
        if (object.getSignal() != null) {
            String signal = object.getSignal().getName();
            result.append(signal);
        } else {
            result.append(object.getName());
        }
        return result.toString();
    }

    public String caseSignalEvent(SignalEvent object) {
        StringBuilder result = new StringBuilder();
        if (object.getSignal() != null) {
            String signal = object.getSignal().getName();
            result.append(signal);
        } else {
            result.append(object.getName());
        }
        return result.toString();
    }
}

