/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.statemachine.custom.policies;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetPropertyCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ComponentEditPolicy;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.diagram.statemachine.custom.commands.CustomRegionDeleteCommand;

public class CustomRegionComponentEditPolicy
extends ComponentEditPolicy {
    protected Command createDeleteViewCommand(GroupRequest deleteRequest) {
        CompositeCommand cc = new CompositeCommand("");
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain == null) {
            return null;
        }
        List toDel = deleteRequest.getEditParts();
        if (toDel == null || toDel.isEmpty()) {
            cc.compose((IUndoableOperation)new CustomRegionDeleteCommand(editingDomain, (View)this.getHost().getModel()));
            View compartmentView = (View)((View)this.getHost().getModel()).eContainer();
            SemanticAdapter adaptableForCompartmentView = new SemanticAdapter(null, (Object)compartmentView);
            if (compartmentView.getChildren().size() == 1) {
                SetPropertyCommand showCompartment = new SetPropertyCommand(editingDomain, (IAdaptable)adaptableForCompartmentView, "notation.View.visible", "Visibility", (Object)false);
                cc.compose((IUndoableOperation)showCompartment);
            }
        } else {
            int i = 0;
            while (i < toDel.size()) {
                IGraphicalEditPart gep = (IGraphicalEditPart)toDel.get(i);
                cc.compose((IUndoableOperation)new CustomRegionDeleteCommand(editingDomain, (View)gep.getModel()));
                View compartmentView = (View)((View)this.getHost().getModel()).eContainer();
                SemanticAdapter adaptableForCompartmentView = new SemanticAdapter(null, (Object)compartmentView);
                if (compartmentView.getChildren().size() == toDel.size()) {
                    SetPropertyCommand showCompartment = new SetPropertyCommand(editingDomain, (IAdaptable)adaptableForCompartmentView, "notation.View.visible", "Visibility", (Object)false);
                    cc.compose((IUndoableOperation)showCompartment);
                }
                ++i;
            }
        }
        return new ICommandProxy(cc.reduce());
    }

    private TransactionalEditingDomain getEditingDomain() {
        EditingDomain domain;
        if (this.getHost() instanceof IGraphicalEditPart) {
            return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        }
        if (this.getHost() instanceof IEditingDomainProvider && (domain = ((IEditingDomainProvider)this.getHost()).getEditingDomain()) instanceof TransactionalEditingDomain) {
            return (TransactionalEditingDomain)domain;
        }
        return null;
    }
}

