/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.statemachine.part;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.diagram.statemachine.part.Messages;
import org.eclipse.papyrus.diagram.statemachine.part.UMLDiagramEditorUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class UMLCreationWizardPage
extends WizardNewFileCreationPage {
    private final String fileExtension;

    public UMLCreationWizardPage(String pageName, IStructuredSelection selection, String fileExtension) {
        super(pageName, selection);
        this.fileExtension = fileExtension;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setFileName(UMLDiagramEditorUtil.getUniqueFileName(this.getContainerFullPath(), this.getFileName(), this.getExtension()));
        this.setPageComplete(this.validatePage());
    }

    protected String getExtension() {
        return this.fileExtension;
    }

    protected IPath getFilePath() {
        String fileName;
        IPath path = this.getContainerFullPath();
        if (path == null) {
            path = new Path("");
        }
        if ((fileName = this.getFileName()) != null) {
            path = path.append(fileName);
        }
        return path;
    }

    public URI getURI() {
        return URI.createPlatformResourceURI((String)this.getFilePath().toString(), (boolean)false);
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        String extension = this.getExtension();
        if (extension != null && !this.getFilePath().toString().endsWith("." + extension)) {
            this.setErrorMessage(NLS.bind((String)Messages.UMLCreationWizardPageExtensionError, (Object)extension));
            return false;
        }
        return true;
    }
}

