/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.usecase.draw2d;

import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public abstract class AbstractProportionalShape
extends Shape {
    private float w2HRatio = 1.0f;
    private boolean keepingProportions;

    protected void setW2HRatio(float w2hRatio) {
        this.w2HRatio = w2hRatio;
        this.keepingProportions = true;
    }

    protected void setKeepingProportions(boolean newValue) {
        this.keepingProportions = newValue;
    }

    protected boolean isKeepingProportions() {
        return this.keepingProportions;
    }

    public Rectangle getProportionalBounds() {
        Rectangle area = this.getClientArea();
        if (!this.keepingProportions || this.w2HRatio == 0.0f || area.height == 0) {
            return new Rectangle(area);
        }
        int newX = area.x;
        int newY = area.y;
        int newW = area.width;
        int newH = area.height;
        float currentRatio = (float)newW / (float)newH;
        float discrepancy = currentRatio / this.w2HRatio;
        if (discrepancy < 1.0f) {
            newH = Math.round((float)newH * discrepancy);
            newY += (area.height - newH) / 2;
        } else {
            newW = Math.round((float)newW / discrepancy);
            newX += (area.width - newW) / 2;
        }
        return new Rectangle(newX, newY, newW, newH);
    }

    public Dimension adjustDimension(Dimension d) {
        Rectangle area = this.getClientArea();
        if (!this.keepingProportions || this.w2HRatio == 0.0f || area.height == 0) {
            return new Dimension(d);
        }
        float currentRatio = (float)area.width / (float)area.height;
        float discrepancy = currentRatio / this.w2HRatio;
        if (discrepancy < 1.0f) {
            return new Dimension(d.width, (int)((float)d.height * discrepancy));
        }
        return new Dimension((int)((float)d.width / discrepancy), d.height);
    }
}

