/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.usecase.draw2d;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.diagram.usecase.draw2d.ShadowShape;
import org.eclipse.swt.graphics.Color;

public class StickMan
extends ShadowShape {
    private static final float BASE_W = 30.0f;
    private static final float BASE_H = 49.0f;
    private static final float FACTOR1 = 0.3265306f;
    private static final float FACTOR2 = 0.4489796f;
    private static final int P_NUM = 20;
    private int ovalX;
    private int ovalY;
    private int ovalD;

    public StickMan() {
        this(false, ColorConstants.white, ColorConstants.black);
    }

    public StickMan(boolean is3D, Color backgroundColor, Color foregroundColor) {
        super(is3D, backgroundColor, foregroundColor);
        this.setKeepingProportions(true);
        this.setW2HRatio(0.6122449f);
    }

    protected void outlineShape(Graphics graphics, Rectangle bounds) {
        PointList pl = this.setupPoints(bounds);
        graphics.drawPolygon(pl);
        int add = graphics.getLineWidth() / 2;
        graphics.drawOval(new Rectangle(this.ovalX, this.ovalY, this.ovalD + add, this.ovalD + add));
    }

    protected void fillShape(Graphics graphics, Rectangle bounds) {
        PointList pl = this.setupPoints(bounds);
        graphics.fillPolygon(pl);
        int add = graphics.getLineWidth() / 2;
        graphics.fillOval(new Rectangle(this.ovalX, this.ovalY, this.ovalD + add, this.ovalD + add));
    }

    protected PointList setupPoints(Rectangle rectangle) {
        int[] xPoints = new int[20];
        int[] yPoints = new int[20];
        PointList pl = new PointList(10);
        int W = rectangle.width / 2 * 2;
        int H = rectangle.height;
        int X1 = W / 2;
        int Y1 = Math.round((float)H * 0.3265306f) / 2 * 2;
        int Y2 = Math.round((float)H * 0.4489796f);
        int Y3 = H - (X1 - 1);
        int STEP = Math.round((float)W / 30.0f);
        if (STEP < 1) {
            STEP = 1;
        }
        xPoints[0] = STEP;
        yPoints[0] = Y1;
        xPoints[1] = STEP;
        yPoints[1] = Y2 - STEP;
        xPoints[2] = X1;
        yPoints[2] = Y2 - STEP;
        xPoints[3] = X1;
        yPoints[3] = Y2 + STEP;
        xPoints[4] = STEP;
        yPoints[4] = Y2 + STEP;
        xPoints[5] = STEP;
        yPoints[5] = Y3 - STEP;
        xPoints[6] = X1;
        yPoints[6] = H - STEP;
        xPoints[7] = X1;
        yPoints[7] = H;
        xPoints[8] = X1 - 2 * STEP;
        yPoints[8] = H;
        xPoints[9] = 0;
        yPoints[9] = Y3 + STEP;
        int i = 0;
        while (i <= 8) {
            xPoints[18 - i] = -xPoints[i];
            yPoints[18 - i] = yPoints[i];
            ++i;
        }
        xPoints[19] = xPoints[0];
        yPoints[19] = yPoints[0];
        i = 0;
        while (i < 20) {
            int n = i;
            xPoints[n] = xPoints[n] + X1;
            int n2 = i;
            xPoints[n2] = xPoints[n2] + rectangle.x;
            int n3 = i++;
            yPoints[n3] = yPoints[n3] + rectangle.y;
        }
        i = 0;
        while (i < xPoints.length) {
            pl.addPoint(xPoints[i], yPoints[i]);
            ++i;
        }
        this.ovalD = Y1;
        this.ovalX = X1 - this.ovalD / 2 + rectangle.x;
        this.ovalY = rectangle.y;
        return pl;
    }
}

