/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.usecase.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.diagram.common.helper.AssociationHelper;
import org.eclipse.papyrus.diagram.usecase.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;

public class AssociationReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public AssociationReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Association)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Type) || !(this.newEnd instanceof Type)) {
            return false;
        }
        if (this.getLink().getEndTypes().size() == 1) {
            return false;
        }
        Type target = (Type)this.getLink().getEndTypes().get(0);
        if (!(this.getLink().eContainer() instanceof Package)) {
            return false;
        }
        Package container = (Package)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistAssociation_4011(container, this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Type) || !(this.newEnd instanceof Type)) {
            return false;
        }
        if (this.getLink().getEndTypes().size() == 1) {
            return false;
        }
        Type source = (Type)this.getLink().getEndTypes().get(0);
        if (!(this.getLink().eContainer() instanceof Package)) {
            return false;
        }
        Package container = (Package)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistAssociation_4011(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        return AssociationHelper.reconnect((int)AssociationHelper.source, (Association)this.getLink(), (Type)this.getNewSource());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        return AssociationHelper.reconnect((int)AssociationHelper.target, (Association)this.getLink(), (Type)this.getNewTarget());
    }

    protected Association getLink() {
        return (Association)this.getElementToEdit();
    }

    protected Type getOldSource() {
        return (Type)this.oldEnd;
    }

    protected Type getNewSource() {
        return (Type)this.newEnd;
    }

    protected Type getOldTarget() {
        return (Type)this.oldEnd;
    }

    protected Type getNewTarget() {
        return (Type)this.newEnd;
    }
}

