/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.usecase.edit.parts;

import org.eclipse.draw2d.Connection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.editparts.UMLConnectionNodeEditPart;
import org.eclipse.papyrus.diagram.common.editpolicies.AppliedStereotypeLinkLabelDisplayEditPolicy;
import org.eclipse.papyrus.diagram.usecase.edit.parts.AssociationAppliedStereotypeEditPart;
import org.eclipse.papyrus.diagram.usecase.edit.parts.AssociationNameEditPart;
import org.eclipse.papyrus.diagram.usecase.edit.policies.AssociationItemSemanticEditPolicy;
import org.eclipse.papyrus.diagram.usecase.figure.AssociationFigure;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Property;

public class AssociationEditPart
extends UMLConnectionNodeEditPart
implements ITreeBranchEditPart {
    public static final int VISUAL_ID = 4011;

    public AssociationEditPart(View view) {
        super(view);
    }

    public void activate() {
        super.activate();
        this.addAssociationEndListeners();
    }

    public void deactivate() {
        this.removeAssociationEndListeners();
        super.deactivate();
    }

    protected void addAssociationEndListeners() {
        this.addListenerFilter("AssociationEndListenersSource", (NotificationListener)this, (EObject)this.getSourceProperty());
        this.addListenerFilter("AssociationEndListenersTarget", (NotificationListener)this, (EObject)this.getTargetProperty());
    }

    protected void removeAssociationEndListeners() {
        this.removeListenerFilter("AssociationEndListenersSource");
        this.removeListenerFilter("AssociationEndListenersTarget");
    }

    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        if (this.resolveSemanticElement() != null) {
            this.refreshVisuals();
        }
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new AssociationItemSemanticEditPolicy());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeLinkLabelDisplayEditPolicy());
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof AssociationNameEditPart) {
            ((AssociationNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getAssociationNameLabel());
            return true;
        }
        if (childEditPart instanceof AssociationAppliedStereotypeEditPart) {
            ((AssociationAppliedStereotypeEditPart)childEditPart).setLabel(this.getPrimaryShape().getAppliedStereotypeLabel());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof AssociationNameEditPart) {
            return true;
        }
        return childEditPart instanceof AssociationAppliedStereotypeEditPart;
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected Connection createConnectionFigure() {
        return new AssociationFigure();
    }

    public AssociationFigure getPrimaryShape() {
        return (AssociationFigure)this.getFigure();
    }

    protected void refreshVisuals() {
        Property source = this.getSourceProperty();
        Property target = this.getTargetProperty();
        int sourceType = 0;
        int targetType = 0;
        if (source != null && source.isNavigable()) {
            ++sourceType;
        }
        if (target != null && target.isNavigable()) {
            ++targetType;
        }
        this.getPrimaryShape().setEnd(sourceType, targetType);
        super.refreshVisuals();
    }

    protected Property getSourceProperty() {
        IGraphicalEditPart graphicalSource = (IGraphicalEditPart)this.getSource();
        if (graphicalSource != null) {
            return this.getRelatedProperty(graphicalSource.resolveSemanticElement());
        }
        return null;
    }

    protected Property getTargetProperty() {
        IGraphicalEditPart graphicalTarget = (IGraphicalEditPart)this.getTarget();
        if (graphicalTarget != null) {
            return this.getRelatedProperty(graphicalTarget.resolveSemanticElement());
        }
        return null;
    }

    protected Property getRelatedProperty(EObject obj) {
        if (obj != null && this.resolveSemanticElement() instanceof Association) {
            EList ends = ((Association)this.resolveSemanticElement()).getMemberEnds();
            for (Property end : ends) {
                if (!obj.equals(end.getType())) continue;
                return end;
            }
        }
        return null;
    }
}

