/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.usecase.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.diagram.usecase.navigator.UMLAbstractNavigatorItem;
import org.eclipse.papyrus.diagram.usecase.navigator.UMLNavigatorGroup;
import org.eclipse.papyrus.diagram.usecase.navigator.UMLNavigatorItem;
import org.eclipse.papyrus.diagram.usecase.part.Messages;
import org.eclipse.papyrus.diagram.usecase.part.UMLVisualIDRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class UMLNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public UMLNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            public void run() {
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                for (Resource nextResource : UMLNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(UMLNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                for (Resource nextResource : UMLNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(UMLNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                for (Resource nextResource : UMLNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(UMLNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }
        });
    }

    private Object[] getViewChildrenForUseCaseDiagramEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup links = new UMLNavigatorGroup(Messages.NavigatorGroupName_Package_1000_links, "icons/linksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2011));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2012));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2015));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2016));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2017));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2018));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4018));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4019));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        if (!links.isEmpty()) {
            result.add(links);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActorEditPartTN(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Actor_2011_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Actor_2011_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4019));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActorAsRectangleEditPartTN(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Actor_2012_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Actor_2012_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4019));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForUseCaseEditPartTN(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_UseCase_2013_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_UseCase_2013_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7009));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3007));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4019));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForUseCaseAsRectangleEditPartTN(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_UseCase_2014_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_UseCase_2014_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7010));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3008));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4019));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForComponentEditPartTN(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Component_2015_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Component_2015_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7011));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3009));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7011));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3016));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7011));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3015));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7011));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3017));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7011));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3018));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4019));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForPackageEditPartTN(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Package_2016_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Package_2016_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3010));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3011));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3012));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3013));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3014));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3015));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4018));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4018));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4019));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4019));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForConstraintEditPartTN(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Constraint_2017_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Constraint_2017_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForCommentEditPartTN(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Comment_2018_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Comment_2018_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForExtensionPointEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ExtensionPoint_3007_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ExtensionPoint_3007_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForExtensionPointInRectangleEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ExtensionPoint_3008_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ExtensionPoint_3008_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForUseCaseInComponentEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_UseCase_3009_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_UseCase_3009_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7012));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3007));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4019));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForComponentInComponentEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Component_3016_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Component_3016_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7017));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3009));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7017));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3016));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7017));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3015));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7017));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3017));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7017));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3018));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4019));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForCommentEditPartCN(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Comment_3015_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Comment_3015_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForConstraintInComponentEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Constraint_3017_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Constraint_3017_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActorInComponentEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Actor_3018_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Actor_3018_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4019));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForConstraintInPackageEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Constraint_3010_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Constraint_3010_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActorInPackageEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Actor_3011_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Actor_3011_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4019));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForUseCaseInPackageEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_UseCase_3012_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_UseCase_3012_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7014));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3007));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4008));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4009));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4019));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForComponentInPackageEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Component_3013_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Component_3013_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7015));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3009));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7015));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3016));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7015));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3015));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7015));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3017));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7015));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3018));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4010));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4011));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4019));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForPackageEditPartCN(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Package_3014_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Package_3014_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7016));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3010));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7016));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3011));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7016));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3012));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7016));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3013));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7016));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3014));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7016));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3015));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4012));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4013));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4014));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4015));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4016));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4017));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4018));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4018));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4019));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4019));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForIncludeEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Include_4008_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Include_4008_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForExtendEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Extend_4009_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Extend_4009_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForGeneralizationEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Generalization_4010_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Generalization_4010_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2015));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2011));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2012));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2015));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3011));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForAssociationEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Association_4011_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Association_4011_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2015));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2011));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2012));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2015));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3011));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForConstraintConstrainedElementEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_ConstraintConstrainedElement_4012_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_ConstraintConstrainedElement_4012_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2015));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3015));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForDependencyEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Dependency_4013_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Dependency_4013_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2015));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2011));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2012));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2015));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3011));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForCommentAnnotatedElementEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_CommentAnnotatedElement_4014_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_CommentAnnotatedElement_4014_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2015));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3015));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2018));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3015));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForAbstractionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Abstraction_4015_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Abstraction_4015_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2015));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2011));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2012));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2015));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3011));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForUsageEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Usage_4016_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Usage_4016_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2015));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2011));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2012));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2015));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3011));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForRealizationEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Realization_4017_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Realization_4017_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2015));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2011));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2012));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2015));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3011));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForPackageMergeEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_PackageMerge_4018_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_PackageMerge_4018_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForPackageImportEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_PackageImport_4019_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_PackageImport_4019_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2011));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2012));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2013));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2014));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2015));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3009));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3011));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList result = new ArrayList();
            return result.toArray();
        }
        if (parentElement instanceof UMLNavigatorGroup) {
            UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof UMLNavigatorItem) {
            UMLNavigatorItem navigatorItem = (UMLNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 4012: {
                return this.getViewChildrenForConstraintConstrainedElementEditPart(view, parentElement);
            }
            case 2018: {
                return this.getViewChildrenForCommentEditPartTN(view, parentElement);
            }
            case 3018: {
                return this.getViewChildrenForActorInComponentEditPart(view, parentElement);
            }
            case 2015: {
                return this.getViewChildrenForComponentEditPartTN(view, parentElement);
            }
            case 4014: {
                return this.getViewChildrenForCommentAnnotatedElementEditPart(view, parentElement);
            }
            case 3009: {
                return this.getViewChildrenForUseCaseInComponentEditPart(view, parentElement);
            }
            case 1000: {
                return this.getViewChildrenForUseCaseDiagramEditPart(view, parentElement);
            }
            case 4018: {
                return this.getViewChildrenForPackageMergeEditPart(view, parentElement);
            }
            case 3012: {
                return this.getViewChildrenForUseCaseInPackageEditPart(view, parentElement);
            }
            case 4019: {
                return this.getViewChildrenForPackageImportEditPart(view, parentElement);
            }
            case 4015: {
                return this.getViewChildrenForAbstractionEditPart(view, parentElement);
            }
            case 3010: {
                return this.getViewChildrenForConstraintInPackageEditPart(view, parentElement);
            }
            case 2017: {
                return this.getViewChildrenForConstraintEditPartTN(view, parentElement);
            }
            case 3017: {
                return this.getViewChildrenForConstraintInComponentEditPart(view, parentElement);
            }
            case 3008: {
                return this.getViewChildrenForExtensionPointInRectangleEditPart(view, parentElement);
            }
            case 2013: {
                return this.getViewChildrenForUseCaseEditPartTN(view, parentElement);
            }
            case 4017: {
                return this.getViewChildrenForRealizationEditPart(view, parentElement);
            }
            case 3007: {
                return this.getViewChildrenForExtensionPointEditPart(view, parentElement);
            }
            case 3011: {
                return this.getViewChildrenForActorInPackageEditPart(view, parentElement);
            }
            case 4016: {
                return this.getViewChildrenForUsageEditPart(view, parentElement);
            }
            case 2016: {
                return this.getViewChildrenForPackageEditPartTN(view, parentElement);
            }
            case 2014: {
                return this.getViewChildrenForUseCaseAsRectangleEditPartTN(view, parentElement);
            }
            case 2012: {
                return this.getViewChildrenForActorAsRectangleEditPartTN(view, parentElement);
            }
            case 3015: {
                return this.getViewChildrenForCommentEditPartCN(view, parentElement);
            }
            case 3016: {
                return this.getViewChildrenForComponentInComponentEditPart(view, parentElement);
            }
            case 3013: {
                return this.getViewChildrenForComponentInPackageEditPart(view, parentElement);
            }
            case 3014: {
                return this.getViewChildrenForPackageEditPartCN(view, parentElement);
            }
            case 2011: {
                return this.getViewChildrenForActorEditPartTN(view, parentElement);
            }
            case 4013: {
                return this.getViewChildrenForDependencyEditPart(view, parentElement);
            }
            case 4011: {
                return this.getViewChildrenForAssociationEditPart(view, parentElement);
            }
            case 4008: {
                return this.getViewChildrenForIncludeEditPart(view, parentElement);
            }
            case 4009: {
                return this.getViewChildrenForExtendEditPart(view, parentElement);
            }
            case 4010: {
                return this.getViewChildrenForGeneralizationEditPart(view, parentElement);
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection getLinksSourceByType(Collection edges, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection getLinksTargetByType(Collection edges, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection getOutgoingLinksByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getSourceEdges(), type));
        }
        return result;
    }

    private Collection getIncomingLinksByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getTargetEdges(), type));
        }
        return result;
    }

    private Collection getChildrenByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getChildren(), type));
        }
        return result;
    }

    private Collection getDiagramLinksByType(Collection diagrams, String type) {
        ArrayList result = new ArrayList();
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection selectViewsByType(Collection views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "UseCase".equals(UMLVisualIDRegistry.getModelID(view));
    }

    private Collection createNavigatorItems(Collection views, Object parent, boolean isLeafs) {
        ArrayList<UMLNavigatorItem> result = new ArrayList<UMLNavigatorItem>();
        Iterator it = views.iterator();
        while (it.hasNext()) {
            result.add(new UMLNavigatorItem((View)it.next(), parent, isLeafs));
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof UMLAbstractNavigatorItem) {
            UMLAbstractNavigatorItem abstractNavigatorItem = (UMLAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }

    static /* synthetic */ Viewer access$0(UMLNavigatorContentProvider uMLNavigatorContentProvider) {
        return uMLNavigatorContentProvider.myViewer;
    }

    static /* synthetic */ AdapterFactoryEditingDomain access$1(UMLNavigatorContentProvider uMLNavigatorContentProvider) {
        return uMLNavigatorContentProvider.myEditingDomain;
    }

    static /* synthetic */ Runnable access$2(UMLNavigatorContentProvider uMLNavigatorContentProvider) {
        return uMLNavigatorContentProvider.myViewerRefreshRunnable;
    }
}

