/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.usecase.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.common.providers.BaseViewInfo;
import org.eclipse.papyrus.diagram.common.providers.ViewInfo;
import org.eclipse.papyrus.diagram.usecase.expressions.UMLOCLFactory;
import org.eclipse.papyrus.diagram.usecase.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Usage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.papyrus.diagram.usecase/debug/visualID";
    private static ViewInfo diagramViewInfo = null;

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("UseCase".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Package)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UseCase".equals(containerModelID)) {
            return -1;
        }
        if ("UseCase".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 2011;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 2012;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 2013;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 2014;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 2015;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 2016;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 2017;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 2018;
                }
                if (!NotationPackage.eINSTANCE.getDiagram().isSuperTypeOf(domainElement.eClass())) break;
                return 2019;
            }
            case 7009: {
                if (!UMLPackage.eINSTANCE.getExtensionPoint().isSuperTypeOf(domainElement.eClass())) break;
                return 3007;
            }
            case 7010: {
                if (!UMLPackage.eINSTANCE.getExtensionPoint().isSuperTypeOf(domainElement.eClass())) break;
                return 3008;
            }
            case 7011: {
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3009;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3016;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3015;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3017;
                }
                if (!UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) break;
                return 3018;
            }
            case 7012: {
                if (!UMLPackage.eINSTANCE.getExtensionPoint().isSuperTypeOf(domainElement.eClass())) break;
                return 3007;
            }
            case 7017: {
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3009;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3016;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3015;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3017;
                }
                if (!UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) break;
                return 3018;
            }
            case 7014: {
                if (!UMLPackage.eINSTANCE.getExtensionPoint().isSuperTypeOf(domainElement.eClass())) break;
                return 3007;
            }
            case 7015: {
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3009;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3016;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3015;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3017;
                }
                if (!UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) break;
                return 3018;
            }
            case 7016: {
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3014;
                }
                if (!UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
            case 7013: {
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getUseCase().isSuperTypeOf(domainElement.eClass())) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3014;
                }
                if (!UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) break;
                return 3015;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"UseCase".equals(containerModelID)) {
            return false;
        }
        if ("UseCase".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2011 == nodeVisualID) {
                    return true;
                }
                if (2012 == nodeVisualID) {
                    return true;
                }
                if (2013 == nodeVisualID) {
                    return true;
                }
                if (2014 == nodeVisualID) {
                    return true;
                }
                if (2015 == nodeVisualID) {
                    return true;
                }
                if (2016 == nodeVisualID) {
                    return true;
                }
                if (2017 == nodeVisualID) {
                    return true;
                }
                if (2018 == nodeVisualID) {
                    return true;
                }
                if (2019 != nodeVisualID) break;
                return true;
            }
            case 2011: {
                if (5014 == nodeVisualID) {
                    return true;
                }
                if (6029 != nodeVisualID) break;
                return true;
            }
            case 2012: {
                if (5015 != nodeVisualID) break;
                return true;
            }
            case 2013: {
                if (5016 == nodeVisualID) {
                    return true;
                }
                if (7009 != nodeVisualID) break;
                return true;
            }
            case 2014: {
                if (5017 == nodeVisualID) {
                    return true;
                }
                if (7010 != nodeVisualID) break;
                return true;
            }
            case 2015: {
                if (5019 == nodeVisualID) {
                    return true;
                }
                if (7011 != nodeVisualID) break;
                return true;
            }
            case 2016: {
                if (5025 == nodeVisualID) {
                    return true;
                }
                if (7013 != nodeVisualID) break;
                return true;
            }
            case 2017: {
                if (5026 != nodeVisualID) break;
                return true;
            }
            case 2018: {
                if (5027 != nodeVisualID) break;
                return true;
            }
            case 2019: {
                if (5032 != nodeVisualID) break;
                return true;
            }
            case 3009: {
                if (5018 == nodeVisualID) {
                    return true;
                }
                if (7012 != nodeVisualID) break;
                return true;
            }
            case 3016: {
                if (5030 == nodeVisualID) {
                    return true;
                }
                if (7017 != nodeVisualID) break;
                return true;
            }
            case 3015: {
                if (5028 != nodeVisualID) break;
                return true;
            }
            case 3017: {
                if (5029 != nodeVisualID) break;
                return true;
            }
            case 3018: {
                if (5031 == nodeVisualID) {
                    return true;
                }
                if (6027 != nodeVisualID) break;
                return true;
            }
            case 3010: {
                if (5020 != nodeVisualID) break;
                return true;
            }
            case 3011: {
                if (5021 == nodeVisualID) {
                    return true;
                }
                if (6028 != nodeVisualID) break;
                return true;
            }
            case 3012: {
                if (5022 == nodeVisualID) {
                    return true;
                }
                if (7014 != nodeVisualID) break;
                return true;
            }
            case 3013: {
                if (5023 == nodeVisualID) {
                    return true;
                }
                if (7015 != nodeVisualID) break;
                return true;
            }
            case 3014: {
                if (5024 == nodeVisualID) {
                    return true;
                }
                if (7016 != nodeVisualID) break;
                return true;
            }
            case 7009: {
                if (3007 != nodeVisualID) break;
                return true;
            }
            case 7010: {
                if (3008 != nodeVisualID) break;
                return true;
            }
            case 7011: {
                if (3009 == nodeVisualID) {
                    return true;
                }
                if (3016 == nodeVisualID) {
                    return true;
                }
                if (3015 == nodeVisualID) {
                    return true;
                }
                if (3017 == nodeVisualID) {
                    return true;
                }
                if (3018 != nodeVisualID) break;
                return true;
            }
            case 7012: {
                if (3007 != nodeVisualID) break;
                return true;
            }
            case 7017: {
                if (3009 == nodeVisualID) {
                    return true;
                }
                if (3016 == nodeVisualID) {
                    return true;
                }
                if (3015 == nodeVisualID) {
                    return true;
                }
                if (3017 == nodeVisualID) {
                    return true;
                }
                if (3018 != nodeVisualID) break;
                return true;
            }
            case 7014: {
                if (3007 != nodeVisualID) break;
                return true;
            }
            case 7015: {
                if (3009 == nodeVisualID) {
                    return true;
                }
                if (3016 == nodeVisualID) {
                    return true;
                }
                if (3015 == nodeVisualID) {
                    return true;
                }
                if (3017 == nodeVisualID) {
                    return true;
                }
                if (3018 != nodeVisualID) break;
                return true;
            }
            case 7016: {
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3014 == nodeVisualID) {
                    return true;
                }
                if (3015 != nodeVisualID) break;
                return true;
            }
            case 7013: {
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3014 == nodeVisualID) {
                    return true;
                }
                if (3015 != nodeVisualID) break;
                return true;
            }
            case 4008: {
                if (6006 == nodeVisualID) {
                    return true;
                }
                if (6030 != nodeVisualID) break;
                return true;
            }
            case 4009: {
                if (6007 == nodeVisualID) {
                    return true;
                }
                if (6031 != nodeVisualID) break;
                return true;
            }
            case 4010: {
                if (6032 != nodeVisualID) break;
                return true;
            }
            case 4011: {
                if (6008 == nodeVisualID) {
                    return true;
                }
                if (6033 != nodeVisualID) break;
                return true;
            }
            case 4013: {
                if (6010 == nodeVisualID) {
                    return true;
                }
                if (6034 != nodeVisualID) break;
                return true;
            }
            case 4015: {
                if (6011 == nodeVisualID) {
                    return true;
                }
                if (6014 != nodeVisualID) break;
                return true;
            }
            case 4016: {
                if (6012 == nodeVisualID) {
                    return true;
                }
                if (6013 != nodeVisualID) break;
                return true;
            }
            case 4017: {
                if (6015 == nodeVisualID) {
                    return true;
                }
                if (6035 != nodeVisualID) break;
                return true;
            }
            case 4018: {
                if (nodeVisualID != 0) break;
                return true;
            }
            case 4019: {
                if (6036 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getInclude().isSuperTypeOf(domainElement.eClass())) {
            return 4008;
        }
        if (UMLPackage.eINSTANCE.getExtend().isSuperTypeOf(domainElement.eClass())) {
            return 4009;
        }
        if (UMLPackage.eINSTANCE.getGeneralization().isSuperTypeOf(domainElement.eClass())) {
            return 4010;
        }
        if (UMLPackage.eINSTANCE.getAssociation().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isAssociation_4011((Association)domainElement)) {
            return 4011;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDependency_4013((Dependency)domainElement)) {
            return 4013;
        }
        if (UMLPackage.eINSTANCE.getAbstraction().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isAbstraction_4015((Abstraction)domainElement)) {
            return 4015;
        }
        if (UMLPackage.eINSTANCE.getUsage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isUsage_4016((Usage)domainElement)) {
            return 4016;
        }
        if (UMLPackage.eINSTANCE.getRealization().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isRealization_4017((Realization)domainElement)) {
            return 4017;
        }
        if (UMLPackage.eINSTANCE.getPackageMerge().isSuperTypeOf(domainElement.eClass())) {
            return 4018;
        }
        if (UMLPackage.eINSTANCE.getPackageImport().isSuperTypeOf(domainElement.eClass())) {
            return 4019;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    private static boolean isAssociation_4011(Association domainElement) {
        Object result = UMLOCLFactory.getExpression(12, (EClassifier)UMLPackage.eINSTANCE.getAssociation(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isDependency_4013(Dependency domainElement) {
        Object result = UMLOCLFactory.getExpression(16, (EClassifier)UMLPackage.eINSTANCE.getDependency(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isAbstraction_4015(Abstraction domainElement) {
        Object result = UMLOCLFactory.getExpression(18, (EClassifier)UMLPackage.eINSTANCE.getAbstraction(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isUsage_4016(Usage domainElement) {
        Object result = UMLOCLFactory.getExpression(19, (EClassifier)UMLPackage.eINSTANCE.getUsage(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isRealization_4017(Realization domainElement) {
        Object result = UMLOCLFactory.getExpression(20, (EClassifier)UMLPackage.eINSTANCE.getRealization(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    public static ViewInfo getDiagramViewInfo() {
        if (diagramViewInfo == null) {
            diagramViewInfo = UMLVisualIDRegistry.getPackage_1000ViewInfo();
        }
        return diagramViewInfo;
    }

    protected static ViewInfo getPackage_1000ViewInfo() {
        BaseViewInfo root = new BaseViewInfo(1000, 0, "", null, null);
        BaseViewInfo viewInfo = null;
        BaseViewInfo labelInfo = null;
        viewInfo = new BaseViewInfo(2011, 2, "Actor");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2012, 2, "Actor");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2013, 2, "UseCase");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2014, 2, "UseCase");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2015, 2, "Component");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2016, 2, "Package");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2017, 2, "Constraint");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2018, 2, "Comment");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(2019, 2, "Diagram");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4008, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6006, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6030, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4009, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6007, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6031, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4010, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6032, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4011, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6008, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6033, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4012, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4013, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6010, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6034, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4014, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(4015, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6011, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6014, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4016, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6012, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6013, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4017, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6015, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        labelInfo = new BaseViewInfo(6035, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4018, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(0, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(4019, 3, "");
        root.addNode(1000, (ViewInfo)viewInfo);
        labelInfo = new BaseViewInfo(6036, 4, "", null, (ViewInfo)viewInfo);
        viewInfo.getChildren().add(labelInfo);
        viewInfo = new BaseViewInfo(3007, 2, "ExtensionPoint");
        root.addNode(7009, (ViewInfo)viewInfo);
        root.addNode(7012, (ViewInfo)viewInfo);
        root.addNode(7014, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3008, 2, "ExtensionPoint");
        root.addNode(7010, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3009, 2, "UseCase");
        root.addNode(7011, (ViewInfo)viewInfo);
        root.addNode(7017, (ViewInfo)viewInfo);
        root.addNode(7015, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3016, 2, "Component");
        root.addNode(7017, (ViewInfo)viewInfo);
        root.addNode(7015, (ViewInfo)viewInfo);
        root.addNode(7011, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3015, 2, "Comment");
        root.addNode(7017, (ViewInfo)viewInfo);
        root.addNode(7015, (ViewInfo)viewInfo);
        root.addNode(7016, (ViewInfo)viewInfo);
        root.addNode(7011, (ViewInfo)viewInfo);
        root.addNode(7013, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3017, 2, "Constraint");
        root.addNode(7017, (ViewInfo)viewInfo);
        root.addNode(7015, (ViewInfo)viewInfo);
        root.addNode(7011, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3018, 2, "Actor");
        root.addNode(7017, (ViewInfo)viewInfo);
        root.addNode(7015, (ViewInfo)viewInfo);
        root.addNode(7011, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3010, 2, "Constraint");
        root.addNode(7016, (ViewInfo)viewInfo);
        root.addNode(7013, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3011, 2, "Actor");
        root.addNode(7016, (ViewInfo)viewInfo);
        root.addNode(7013, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3012, 2, "UseCase");
        root.addNode(7016, (ViewInfo)viewInfo);
        root.addNode(7013, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3013, 2, "Component");
        root.addNode(7016, (ViewInfo)viewInfo);
        root.addNode(7013, (ViewInfo)viewInfo);
        viewInfo = new BaseViewInfo(3014, 2, "Package");
        root.addNode(7016, (ViewInfo)viewInfo);
        root.addNode(7013, (ViewInfo)viewInfo);
        return root;
    }
}

