/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.uml;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.documentation.IDocumentationChangedListener;
import org.eclipse.papyrus.documentation.Messages;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLAddOrRemoveAssociatedResourceCommand
extends AbstractCommand {
    private Element element;
    private Comment documentationComment = null;
    private Stereotype documentationStereotype = null;
    private Set<IDocumentationChangedListener> documentationChangedListeners;
    private boolean remove;
    private String resourceURIString;

    public UMLAddOrRemoveAssociatedResourceCommand(boolean remove, Element element, URI resourceURI, Set<IDocumentationChangedListener> documentationChangedListeners) {
        super(Messages.AddOrRemoveAssociatedResourceCommandLabel);
        this.remove = remove;
        this.element = element;
        this.resourceURIString = resourceURI.toString();
        this.documentationChangedListeners = documentationChangedListeners;
    }

    public boolean canExecute() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        EList ownedComments = this.element.getOwnedComments();
        for (Comment comment : ownedComments) {
            this.documentationStereotype = comment.getAppliedStereotype("Papyrus::Documentation::Documentation");
            if (this.documentationStereotype == null) continue;
            this.documentationComment = comment;
            break;
        }
        this.redo();
    }

    private void notifyListeners() {
        for (IDocumentationChangedListener listener : this.documentationChangedListeners) {
            listener.documentationChanged((EObject)this.element);
        }
    }

    public void redo() {
        if (this.remove) {
            this.removeAssociatedResource();
        } else {
            this.addAssociatedResource();
        }
    }

    public void undo() {
        if (this.remove) {
            this.addAssociatedResource();
        } else {
            this.removeAssociatedResource();
        }
    }

    private void removeAssociatedResource() {
        if (this.documentationStereotype != null && this.documentationComment != null) {
            List resourceURIs = (List)this.documentationComment.getValue(this.documentationStereotype, "associatedResource");
            resourceURIs.remove(this.resourceURIString);
            this.notifyListeners();
        }
    }

    private void addAssociatedResource() {
        if (this.documentationStereotype != null && this.documentationComment != null) {
            List resourceURIs = (List)this.documentationComment.getValue(this.documentationStereotype, "associatedResource");
            resourceURIs.add(this.resourceURIString);
            this.notifyListeners();
        }
    }
}

