/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.uml;

import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.documentation.IDocumentationChangedListener;
import org.eclipse.papyrus.documentation.Messages;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLChangeDocumentationCommand
extends AbstractCommand {
    private Element element;
    private String newComment;
    private String oldComment;
    private Comment documentationComment = null;
    private Stereotype documentationStereotype = null;
    private boolean profileWasAlreadyApplied = false;
    private Set<IDocumentationChangedListener> documentationChangedListeners;

    public UMLChangeDocumentationCommand(Element element, String newDocumentation, Set<IDocumentationChangedListener> documentationChangedListeners) {
        super(Messages.ChangeDocCommandLabel);
        this.element = element;
        this.newComment = newDocumentation;
        this.documentationChangedListeners = documentationChangedListeners;
    }

    public boolean canExecute() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        this.profileWasAlreadyApplied = this.element.getNearestPackage().getAppliedProfile("Papyrus::Documentation", true) != null;
        this.oldComment = null;
        EList ownedComments = this.element.getOwnedComments();
        for (Comment comment : ownedComments) {
            this.documentationStereotype = comment.getAppliedStereotype("Papyrus::Documentation::Documentation");
            if (this.documentationStereotype == null) continue;
            this.documentationComment = comment;
            break;
        }
        if (this.documentationComment != null) {
            this.oldComment = this.documentationComment.getBody();
        }
        this.redo();
    }

    private void notifyListeners() {
        for (IDocumentationChangedListener listener : this.documentationChangedListeners) {
            listener.documentationChanged((EObject)this.element);
        }
    }

    public void redo() {
        this.changeDocumentation(this.newComment);
    }

    public void undo() {
        this.changeDocumentation(this.oldComment);
    }

    private IStatus changeDocumentation(String newDoc) {
        if (newDoc != null) {
            if (this.documentationComment == null) {
                this.documentationComment = UMLFactory.eINSTANCE.createComment();
                this.element.getOwnedComments().add((Object)this.documentationComment);
                this.applyDocumentationStereotype(this.documentationComment);
            }
            this.documentationComment.setBody(newDoc);
        } else {
            this.removeDocumentation();
        }
        this.notifyListeners();
        return Status.OK_STATUS;
    }

    private void removeDocumentation() {
        Profile documentationProfile;
        if (this.documentationComment != null) {
            Stereotype documentationStereotype = this.documentationComment.getAppliedStereotype("Papyrus::Documentation::Documentation");
            if (documentationStereotype != null) {
                this.documentationComment.unapplyStereotype(documentationStereotype);
            }
            this.element.getOwnedComments().remove((Object)this.documentationComment);
            this.documentationComment = null;
        }
        if (!this.profileWasAlreadyApplied && (documentationProfile = this.element.getNearestPackage().getAppliedProfile("Papyrus::Documentation", true)) != null) {
            this.element.getNearestPackage().unapplyProfile(documentationProfile);
        }
    }

    public void applyDocumentationStereotype(Comment comment) {
        Stereotype documentationStereotype;
        Profile documentationProfile = this.element.getNearestPackage().getAppliedProfile("Papyrus::Documentation", true);
        if (documentationProfile == null) {
            Profile papyrusProfile;
            NamedElement possibleDocumentationProfile;
            Resource papyrusProfileResource;
            ResourceSet rs = null;
            Resource resource = this.element.eResource();
            if (resource != null) {
                rs = resource.getResourceSet();
            }
            if (rs == null) {
                rs = new ResourceSetImpl();
            }
            if ((papyrusProfileResource = rs.getResource(URI.createURI((String)"pathmap://Papyrus.profile.uml"), true)) != null && !papyrusProfileResource.getContents().isEmpty() && papyrusProfileResource.getContents().get(0) instanceof Profile && (possibleDocumentationProfile = (papyrusProfile = (Profile)papyrusProfileResource.getContents().get(0)).getMember("Documentation")) instanceof Profile) {
                documentationProfile = (Profile)possibleDocumentationProfile;
                this.element.getNearestPackage().applyProfile(documentationProfile);
            }
        }
        if (documentationProfile != null && (documentationStereotype = documentationProfile.getOwnedStereotype("Documentation")) != null) {
            comment.applyStereotype(documentationStereotype);
        }
    }
}

