/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.uml;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.documentation.DocumentationUnsupportedException;
import org.eclipse.papyrus.documentation.IDocumentationChangedListener;
import org.eclipse.papyrus.documentation.IDocumentationManager;
import org.eclipse.papyrus.documentation.uml.Messages;
import org.eclipse.papyrus.documentation.uml.UMLAddOrRemoveAssociatedResourceCommand;
import org.eclipse.papyrus.documentation.uml.UMLChangeDocumentationCommand;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLDocumentationManager
implements IDocumentationManager {
    private static Set<IDocumentationChangedListener> documentationChangedListeners = new HashSet<IDocumentationChangedListener>();

    public static UMLDocumentationManager getInstance() {
        return UMLDocumentationManagerHolder.instance;
    }

    public Command getChangeDocumentationCommand(EObject eObject, String newDocumentation) {
        if (UMLDocumentationManager.getUnsupportedErrorMessage(eObject) == null) {
            return new UMLChangeDocumentationCommand((Element)eObject, newDocumentation, documentationChangedListeners);
        }
        return null;
    }

    public String getDocumentation(EObject eObject) throws DocumentationUnsupportedException {
        String errorMsg = UMLDocumentationManager.getUnsupportedErrorMessage(eObject);
        if (errorMsg == null) {
            EList ownedComments = ((Element)eObject).getOwnedComments();
            for (Comment comment : ownedComments) {
                if (comment.getAppliedStereotype("Papyrus::Documentation::Documentation") == null) continue;
                return comment.getBody();
            }
            return null;
        }
        throw new DocumentationUnsupportedException(errorMsg);
    }

    public List<URI> getAssociatedResources(EObject eObject) throws DocumentationUnsupportedException {
        String errorMsg = UMLDocumentationManager.getUnsupportedErrorMessage(eObject);
        if (errorMsg == null) {
            LinkedList<URI> URIs = new LinkedList<URI>();
            EList ownedComments = ((Element)eObject).getOwnedComments();
            for (Comment comment : ownedComments) {
                Stereotype docStereotype = comment.getAppliedStereotype("Papyrus::Documentation::Documentation");
                if (docStereotype == null) continue;
                List stringURIs = (List)comment.getValue(docStereotype, "associatedResource");
                for (String stringURI : stringURIs) {
                    URIs.add(URI.createURI((String)stringURI));
                }
            }
            return URIs;
        }
        throw new DocumentationUnsupportedException(errorMsg);
    }

    public void registerDocumentationChangedListener(IDocumentationChangedListener listener) {
        documentationChangedListeners.add(listener);
    }

    public void unregisterDocumentationChangedListener(IDocumentationChangedListener listener) {
        documentationChangedListeners.remove(listener);
    }

    public Set<IDocumentationChangedListener> getRegisteredDocumentationChangedListeners() {
        return documentationChangedListeners;
    }

    private static String getUnsupportedErrorMessage(EObject eObject) {
        if (eObject instanceof Comment && ((Comment)eObject).getAppliedStereotype("Papyrus::Documentation::Documentation") != null) {
            return Messages.UMLDocumentationManager_DocOnDocCommentError;
        }
        if (eObject instanceof Element) {
            return null;
        }
        return Messages.UMLDocumentationManager_NonUMLElementError;
    }

    public Command getAddAssociatedResourceCommand(EObject eObject, URI resourceURI) {
        if (UMLDocumentationManager.getUnsupportedErrorMessage(eObject) == null) {
            return new UMLAddOrRemoveAssociatedResourceCommand(false, (Element)eObject, resourceURI, documentationChangedListeners);
        }
        return null;
    }

    public Command getRemoveAssociatedResourceCommand(EObject eObject, URI resourceURI) {
        if (UMLDocumentationManager.getUnsupportedErrorMessage(eObject) == null) {
            return new UMLAddOrRemoveAssociatedResourceCommand(true, (Element)eObject, resourceURI, documentationChangedListeners);
        }
        return null;
    }

    private static class UMLDocumentationManagerHolder {
        public static final UMLDocumentationManager instance = new UMLDocumentationManager();

        private UMLDocumentationManagerHolder() {
        }
    }
}

