/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.view.papyrus;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.core.adaptor.gmf.DiagramsUtil;
import org.eclipse.papyrus.core.editor.CoreMultiDiagramEditor;
import org.eclipse.papyrus.documentation.DocumentationManager;
import org.eclipse.papyrus.documentation.IDocumentationManager;
import org.eclipse.papyrus.documentation.view.IDocumentationPartHandler;
import org.eclipse.papyrus.documentation.view.SelectResourceDialog;
import org.eclipse.papyrus.modelexplorer.MoDiscoContentProvider;
import org.eclipse.papyrus.modelexplorer.MoDiscoLabelProvider;
import org.eclipse.papyrus.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageMngr;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class PapyrusDocumentationPartHandler
implements IDocumentationPartHandler {
    public boolean canHandlePart(IWorkbenchPart part) {
        return part instanceof CoreMultiDiagramEditor || part instanceof ModelExplorerPageBookView;
    }

    public IDocumentationManager getDocumentationManager() {
        return DocumentationManager.getInstance();
    }

    public void executeCommand(IWorkbenchPart part, Command cmd) {
        CoreMultiDiagramEditor editor = PapyrusDocumentationPartHandler.getPapyrusEditor(part);
        if (editor != null && cmd != null) {
            TransactionalEditingDomain domain = (TransactionalEditingDomain)editor.getEditingDomain();
            domain.getCommandStack().execute(cmd);
        }
    }

    public EObject getAssociatedDiagram(IWorkbenchPart part, EObject eObject) {
        Diagram currentDiagram;
        if (eObject instanceof Diagram) {
            return null;
        }
        if (eObject != null && part instanceof IDiagramWorkbenchPart && (currentDiagram = ((IDiagramWorkbenchPart)part).getDiagram()) != null && eObject.equals(currentDiagram.getElement())) {
            return currentDiagram;
        }
        return null;
    }

    public void openElement(IWorkbenchPart part, URI elementUri) {
        try {
            EditingDomain ed;
            CoreMultiDiagramEditor editor = PapyrusDocumentationPartHandler.getPapyrusEditor(part);
            if (editor != null && (ed = editor.getEditingDomain()) != null) {
                IPageMngr pageMngr;
                EObject eObject = ed.getResourceSet().getEObject(elementUri, false);
                Diagram diagram = null;
                if (eObject instanceof Diagram) {
                    diagram = (Diagram)eObject;
                } else {
                    List diagrams = DiagramsUtil.getAssociatedDiagrams((EObject)eObject, null);
                    if (!diagrams.isEmpty()) {
                        diagram = (Diagram)diagrams.get(0);
                    }
                }
                if (diagram != null && (pageMngr = (IPageMngr)editor.getAdapter(IPageMngr.class)) != null) {
                    if (pageMngr.isOpen((Object)diagram)) {
                        pageMngr.closePage((Object)diagram);
                    }
                    pageMngr.openPage((Object)diagram);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public EObject openElementSelectionDialog(IWorkbenchPart part) {
        Object selectedElement = null;
        CoreMultiDiagramEditor editor = PapyrusDocumentationPartHandler.getPapyrusEditor(part);
        if (editor != null) {
            ISelectionStatusValidator validator = new ISelectionStatusValidator(){

                public IStatus validate(Object[] selectedElements) {
                    Object selectedElement;
                    boolean enableOK = false;
                    if (selectedElements.length == 1 && PapyrusDocumentationPartHandler.adapt(selectedElement = selectedElements[0]) != null) {
                        enableOK = true;
                    }
                    String msg = "";
                    if (!enableOK) {
                        msg = "Only one EObject can be selected";
                    }
                    return enableOK ? new Status(0, "org.eclipse.emf.common.ui", 0, msg, null) : new Status(4, "org.eclipse.emf.common.ui", 0, msg, null);
                }
            };
            selectedElement = SelectResourceDialog.openElementSelection((Object)editor.getServicesRegistry(), (ILabelProvider)new MoDiscoLabelProvider(), (ITreeContentProvider)new MoDiscoContentProvider(), (ISelectionStatusValidator)validator, null, (boolean)true);
        }
        return PapyrusDocumentationPartHandler.adapt(selectedElement);
    }

    public boolean isReadOnly(IWorkbenchPart part, EObject eObject) {
        CoreMultiDiagramEditor editor = PapyrusDocumentationPartHandler.getPapyrusEditor(part);
        if (editor != null && eObject != null) {
            TransactionalEditingDomain domain = (TransactionalEditingDomain)editor.getEditingDomain();
            return domain.isReadOnly(eObject.eResource());
        }
        return false;
    }

    private static EObject adapt(Object obj) {
        if (obj instanceof EObject) {
            return (EObject)obj;
        }
        if (obj instanceof IAdaptable) {
            EObject adapted = (EObject)((IAdaptable)obj).getAdapter(EObject.class);
            return adapted;
        }
        return null;
    }

    private static CoreMultiDiagramEditor getPapyrusEditor(IWorkbenchPart part) {
        if (part instanceof CoreMultiDiagramEditor) {
            return (CoreMultiDiagramEditor)part;
        }
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor instanceof CoreMultiDiagramEditor) {
            return (CoreMultiDiagramEditor)activeEditor;
        }
        return null;
    }
}

