/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.view.papyrus;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.EditingDomainUndoContext;

public class TransactionalUncheckedCommandProxy
extends AbstractTransactionalCommand {
    private Command command;

    public TransactionalUncheckedCommandProxy(TransactionalEditingDomain editingDomain, Command command) {
        super(editingDomain, command.getLabel() == null ? "" : command.getLabel(), null);
        Assert.isNotNull((Object)command);
        this.command = command;
        this.addContext((IUndoContext)new EditingDomainUndoContext((EditingDomain)editingDomain));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.command.execute();
        return CommandResult.newOKCommandResult();
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.command.undo();
        this.setResult(CommandResult.newOKCommandResult());
        return Status.OK_STATUS;
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.command.redo();
        this.setResult(CommandResult.newOKCommandResult());
        return Status.OK_STATUS;
    }

    public Command getCommand() {
        return this.command;
    }

    public boolean canUndo() {
        return this.command.canUndo();
    }

    public boolean canExecute() {
        return this.command.canExecute();
    }

    public boolean canRedo() {
        return this.canExecute() && this.canUndo();
    }

    public void dispose() {
        super.dispose();
        this.command.dispose();
    }
}

