/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.view;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.papyrus.documentation.DocumentationUnsupportedException;
import org.eclipse.papyrus.documentation.view.DocPageComposite;
import org.eclipse.papyrus.documentation.view.DocViewPlugin;
import org.eclipse.papyrus.documentation.view.DocumentionPartHandlerRegistry;
import org.eclipse.papyrus.documentation.view.IDocumentationPartHandler;
import org.eclipse.papyrus.documentation.view.Messages;
import org.eclipse.papyrus.documentation.view.PlainTextComposite;
import org.eclipse.papyrus.documentation.view.RichTextComposite;
import org.eclipse.papyrus.documentation.view.RichTextEditorDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CommentsComposite
extends DocPageComposite {
    private RichTextComposite richTextComposite;
    private PlainTextComposite plainTextComposite;
    private Button useRichTextEditorButton;
    private Button editButton;
    private Composite editorContainer;
    private FocusListener focusListener;
    private Text infoText;
    private static String typeLabel = Messages.CommentsComposite_docCurrent;
    private static boolean isRichTextEnabled = true;

    public CommentsComposite(Composite parent, int style) {
        super(parent, style);
    }

    protected void createContents(Composite parent) {
        boolean labelForTypeInformation;
        boolean bl = labelForTypeInformation = (this.getStyle() & 0x10000000) != 0;
        if (labelForTypeInformation) {
            this.infoText = new Text(parent, 8);
        }
        parent.setLayout((Layout)new GridLayout(3, false));
        this.editorContainer = new Composite(parent, 0);
        GridData gData = new GridData(1808);
        gData.horizontalSpan = 3;
        this.editorContainer.setLayoutData((Object)gData);
        this.editorContainer.setLayout((Layout)new FillLayout());
        if (isRichTextEnabled) {
            try {
                Browser browser = new Browser(this.editorContainer, 0);
                browser.dispose();
            }
            catch (SWTError swtError) {
                isRichTextEnabled = false;
            }
        }
        this.plainTextComposite = this.createPlainCommentsComposite();
        this.useRichTextEditorButton = new Button(parent, 131104);
        this.useRichTextEditorButton.setText("Use HTML Editor");
        this.useRichTextEditorButton.setImage(DocViewPlugin.getDefault().getImageRegistry().get("HTML_EDITOR"));
        this.useRichTextEditorButton.setSelection(false);
        this.useRichTextEditorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommentsComposite.this.changeEditor();
            }
        });
        Label emptyLbl = new Label(parent, 0);
        emptyLbl.setLayoutData((Object)new GridData(768));
        this.editButton = new Button(parent, 8);
        this.editButton.setImage(DocViewPlugin.getDefault().getImageRegistry().get("EDIT"));
        this.editButton.setText("Edit");
        this.editButton.setEnabled(this.useRichTextEditorButton.getSelection());
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RichTextEditorDialog dialog = new RichTextEditorDialog(CommentsComposite.this.getShell(), CommentsComposite.this.getDocumentationValueFromElement());
                if (dialog.open() == 0) {
                    CommentsComposite.this.richTextComposite.setDocumentationValue(dialog.getDocumentationValue());
                    CommentsComposite.this.handleDocChanged();
                }
            }
        });
        if (this.infoText != null) {
            this.infoText.setLayoutData((Object)new GridData(768));
        }
    }

    protected void refresh() {
        EObject docElement = this.getDocumentedElement();
        this.useRichTextEditorButton.setEnabled(docElement != null);
        if (this.useRichTextEditorButton.getSelection()) {
            this.richTextComposite.setDocumentationValue("");
            if (docElement != null) {
                this.richTextComposite.setDocumentationValue(this.getDocumentationValueFromElement());
            }
        } else {
            this.plainTextComposite.setDocumentationValue("");
            this.plainTextComposite.getControl().setEnabled(docElement != null);
            if (docElement != null) {
                this.plainTextComposite.setDocumentationValue(this.getDocumentationValueFromElement());
            }
        }
        if (this.infoText != null) {
            if (docElement != null) {
                this.infoText.setText(String.valueOf(typeLabel) + docElement.eClass().getName());
            } else {
                this.infoText.setText("");
            }
        }
    }

    protected RichTextComposite getRichTextComposite() {
        return this.richTextComposite;
    }

    public PlainTextComposite getPlainTextComposite() {
        return this.plainTextComposite;
    }

    public void changeEditor() {
        if (!this.useRichTextEditorButton.getSelection()) {
            String comment = this.richTextComposite.getDocumentationValue();
            this.richTextComposite.dispose();
            this.plainTextComposite = this.createPlainCommentsComposite();
            this.plainTextComposite.setFocus();
            this.plainTextComposite.setDocumentationValue(comment);
            this.useRichTextEditorButton.setToolTipText("Use HTML Editor to edit documentation");
            this.useRichTextEditorButton.setSelection(false);
            this.editButton.setEnabled(false);
        } else if (isRichTextEnabled) {
            String comment = this.plainTextComposite.getDocumentationValue();
            this.plainTextComposite.getControl().removeFocusListener(this.focusListener);
            this.plainTextComposite.dispose();
            this.richTextComposite = this.createRichCommentsComposite();
            this.richTextComposite.setDocumentationValue(comment);
            this.useRichTextEditorButton.setToolTipText("Use Text Editor to edit documentation");
            this.useRichTextEditorButton.setSelection(true);
            this.editButton.setEnabled(true);
            this.editButton.setFocus();
        } else {
            this.showMessageDialog();
            this.useRichTextEditorButton.setSelection(false);
        }
        this.editorContainer.layout();
    }

    private void showMessageDialog() {
        MessageDialog dialog = new MessageDialog(this.getShell(), "Rich Text Edition unavailable", null, "Your operating system does not support the SWT Browser component, thus you are not able to edit documentation using rich text capabilities.\nYou should try installing XULRunner in your environment so that you can enable Rich Text Edition, and then restart your application.\nTo install XulRunner, have a look at : <a>http://www.eclipse.org/atf/downloads/base_files/manualXulrunner_section.php</a>.", 4, new String[]{IDialogConstants.OK_LABEL}, 0){

            protected Control createMessageArea(Composite composite) {
                Image image = this.getImage();
                if (image != null) {
                    this.imageLabel = new Label(composite, 0);
                    image.setBackground(this.imageLabel.getBackground());
                    this.imageLabel.setImage(image);
                    GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
                }
                if (this.message != null) {
                    Link messageLink = new Link(composite, this.getMessageLabelStyle());
                    messageLink.setText(this.message);
                    messageLink.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            try {
                                PlatformUI.getWorkbench().getBrowserSupport().createBrowser(null).openURL(new URL(event.text));
                                this.okPressed();
                            }
                            catch (PartInitException partInitException) {
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                        }
                    });
                    GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)messageLink);
                }
                return composite;
            }
        };
        dialog.open();
    }

    protected RichTextComposite createRichCommentsComposite() {
        this.richTextComposite = new RichTextComposite(this.editorContainer, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.richTextComposite.setLayout((Layout)layout);
        return this.richTextComposite;
    }

    protected PlainTextComposite createPlainCommentsComposite() {
        this.plainTextComposite = new PlainTextComposite(this.editorContainer, 0);
        this.focusListener = new FocusAdapter(){
            private String previousComment;

            public void focusGained(FocusEvent e) {
                this.previousComment = CommentsComposite.this.plainTextComposite.getDocumentationValue();
            }

            public void focusLost(FocusEvent e) {
                if (!CommentsComposite.this.plainTextComposite.getDocumentationValue().equals(this.previousComment)) {
                    CommentsComposite.this.handleDocChanged();
                }
            }
        };
        this.plainTextComposite.getTextControl().addFocusListener(this.focusListener);
        return this.plainTextComposite;
    }

    public boolean setFocus() {
        if (this.useRichTextEditorButton == null) {
            return false;
        }
        if (this.useRichTextEditorButton.getSelection()) {
            return this.editButton.setFocus();
        }
        if (this.plainTextComposite == null) {
            return false;
        }
        return this.plainTextComposite.setFocus();
    }

    protected Button getUseRichTextEditorButton() {
        return this.useRichTextEditorButton;
    }

    protected Button getEditButton() {
        return this.editButton;
    }

    protected String getDocumentationValueFromElement() {
        try {
            IDocumentationPartHandler documentationPartHandler = DocumentionPartHandlerRegistry.getInstance().getDocumentationPartHandler(this.getActivePart());
            if (documentationPartHandler != null) {
                EObject associatedDiagram = documentationPartHandler.getAssociatedDiagram(this.getActivePart(), this.getDocumentedElement());
                EObject toDocument = associatedDiagram == null ? this.getDocumentedElement() : associatedDiagram;
                return documentationPartHandler.getDocumentationManager().getDocumentation(toDocument);
            }
        }
        catch (DocumentationUnsupportedException documentationUnsupportedException) {
            // empty catch block
        }
        return "";
    }

    public void handleDocChanged() {
        IDocumentationPartHandler documentationPartHandler = DocumentionPartHandlerRegistry.getInstance().getDocumentationPartHandler(this.getActivePart());
        if (documentationPartHandler != null) {
            String docValue = this.getUseRichTextEditorButton().getSelection() ? this.getRichTextComposite().getDocumentationValue() : this.getPlainTextComposite().getDocumentationValue();
            Command cmd = documentationPartHandler.getDocumentationManager().getChangeDocumentationCommand(this.getDocumentedElement(), docValue);
            documentationPartHandler.executeCommand(this.getActivePart(), cmd);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.plainTextComposite != null) {
            this.plainTextComposite.setEnabled(enabled);
        }
        if (this.richTextComposite != null) {
            this.richTextComposite.setEnabled(enabled);
        }
        if (this.useRichTextEditorButton != null) {
            this.useRichTextEditorButton.setEnabled(enabled);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.plainTextComposite != null) {
            this.plainTextComposite.setForeground(color);
        }
        if (this.richTextComposite != null) {
            this.richTextComposite.setForeground(color);
        }
    }
}

