/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.view;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.documentation.view.CommentsComposite;
import org.eclipse.papyrus.documentation.view.DocumentionPartHandlerRegistry;
import org.eclipse.papyrus.documentation.view.IDocPage;
import org.eclipse.papyrus.documentation.view.IDocumentationPartHandler;
import org.eclipse.papyrus.documentation.view.Messages;
import org.eclipse.papyrus.documentation.view.ResourcesComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;

public class DocPage
extends Page
implements IDocPage {
    private EObject documentedElement;
    private Composite mainComp;
    protected CommentsComposite commentsComposite;
    protected ResourcesComposite resourcesComposite;
    private TabFolder tabFolder;
    public static final int STYLE_TEXT_TYPE = 0x10000000;

    public void createControl(Composite parent) {
        this.mainComp = new Composite(parent, 0);
        this.mainComp.setLayout((Layout)new GridLayout());
        this.mainComp.setLayoutData((Object)new GridData(1808));
        this.tabFolder = new TabFolder(this.mainComp, 128);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.createCommentsTabItem(this.tabFolder);
        this.createResourcesTabItem(this.tabFolder);
    }

    private void createCommentsTabItem(TabFolder parent) {
        TabItem tabItem = new TabItem(parent, 0);
        tabItem.setText(Messages.AbstractDocPage_commentsTitle);
        Composite container = new Composite((Composite)parent, 0);
        GridLayout containerLayout = new GridLayout();
        containerLayout.marginWidth = 0;
        containerLayout.marginHeight = 0;
        container.setLayout((Layout)containerLayout);
        container.setLayoutData((Object)new GridData(1808));
        tabItem.setControl((Control)container);
        this.commentsComposite = this.createCommentsComposite(container);
        this.commentsComposite.setLayoutData(new GridData(1808));
    }

    private void createResourcesTabItem(TabFolder parent) {
        TabItem tabItem = new TabItem(parent, 0);
        tabItem.setText(Messages.AbstractDocPage_resourcesTitle);
        Composite container = new Composite((Composite)parent, 0);
        GridLayout containerLayout = new GridLayout();
        containerLayout.marginWidth = 0;
        containerLayout.marginHeight = 0;
        container.setLayout((Layout)containerLayout);
        container.setLayoutData((Object)new GridData(1808));
        tabItem.setControl((Control)container);
        this.resourcesComposite = new ResourcesComposite(container, 0);
        this.resourcesComposite.setLayoutData(new GridData(1808));
    }

    public Control getControl() {
        return this.mainComp;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.manageDocumentatedElement(part, selection, true);
    }

    protected void manageDocumentatedElement(IWorkbenchPart part, ISelection selection, boolean checkResources) {
        EObject elt = this.getSelectedModelElement(selection);
        if (elt == null || elt != this.documentedElement) {
            IDocumentationPartHandler documentationPartHandler;
            this.documentedElement = elt;
            if (this.commentsComposite != null && !this.commentsComposite.isDisposed()) {
                this.commentsComposite.setActivePart(part);
                this.commentsComposite.setDocumentedElement(this.documentedElement);
            }
            if (this.resourcesComposite != null && !this.resourcesComposite.isDisposed()) {
                this.resourcesComposite.setActivePart(part);
                this.resourcesComposite.setDocumentedElement(this.documentedElement);
            }
            if (this.documentedElement != null && checkResources && (documentationPartHandler = DocumentionPartHandlerRegistry.getInstance().getDocumentationPartHandler(part)) != null) {
                boolean readOnly = documentationPartHandler.isReadOnly(part, this.documentedElement);
                this.commentsComposite.setReadOnly(readOnly);
                this.resourcesComposite.setReadOnly(readOnly);
            }
        }
    }

    public void setFocus() {
        if (this.commentsComposite != null && !this.commentsComposite.isDisposed()) {
            this.commentsComposite.setFocus();
        }
    }

    protected CommentsComposite createCommentsComposite(Composite parent) {
        return new CommentsComposite(parent, 0x10000000);
    }

    protected EObject getSelectedModelElement(ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object adaptedObject;
            Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
            if (selectedObject instanceof EObject) {
                return (EObject)selectedObject;
            }
            if (selectedObject instanceof IAdaptable && (adaptedObject = ((IAdaptable)selectedObject).getAdapter(EObject.class)) != null) {
                return (EObject)adaptedObject;
            }
            adaptedObject = Platform.getAdapterManager().getAdapter(selectedObject, EObject.class);
            if (adaptedObject != null) {
                return (EObject)adaptedObject;
            }
        }
        return null;
    }
}

