/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.view;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.documentation.DocumentationManager;
import org.eclipse.papyrus.documentation.IDocumentationChangedListener;
import org.eclipse.papyrus.documentation.view.DocumentionPartHandlerRegistry;
import org.eclipse.papyrus.documentation.view.IDocumentationPartHandler;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;

public abstract class DocPageComposite
extends Composite
implements IDocumentationChangedListener {
    IWorkbenchPart activePart = null;
    private EObject documentedElement;

    public DocPageComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DocPageComposite.this.handleDispose();
            }
        });
        DocumentationManager.getInstance().registerDocumentationChangedListener((IDocumentationChangedListener)this);
        this.createContents(this);
    }

    public void setDocumentedElement(EObject modelElement) {
        if (modelElement == null || this.documentedElement != modelElement) {
            this.documentedElement = modelElement;
            this.refresh();
        }
    }

    public EObject getDocumentedElement() {
        EObject associatedDiagram;
        IDocumentationPartHandler documentationPartHandler = DocumentionPartHandlerRegistry.getInstance().getDocumentationPartHandler(this.getActivePart());
        if (documentationPartHandler != null && (associatedDiagram = documentationPartHandler.getAssociatedDiagram(this.getActivePart(), this.documentedElement)) != null) {
            return associatedDiagram;
        }
        return this.documentedElement;
    }

    public void setActivePart(IWorkbenchPart part) {
        this.activePart = part;
    }

    public IWorkbenchPart getActivePart() {
        return this.activePart;
    }

    protected void handleDispose() {
        DocumentationManager.getInstance().unregisterDocumentationChangedListener((IDocumentationChangedListener)this);
    }

    protected abstract void createContents(Composite var1);

    protected void refresh() {
    }

    public void setReadOnly(boolean readOnly) {
        this.setEnabled(!readOnly);
    }

    public void documentationChanged(EObject eObject) {
        if (Display.getCurrent() != Display.getDefault()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    DocPageComposite.this.refresh();
                }
            });
        } else {
            this.refresh();
        }
    }
}

