/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.view;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.documentation.view.DocPage;
import org.eclipse.papyrus.documentation.view.DocumentionPartHandlerRegistry;
import org.eclipse.papyrus.documentation.view.EmptyDocPage;
import org.eclipse.papyrus.documentation.view.IDocPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public class DocView
extends PageBookView
implements ISelectionListener {
    public static final String VIEW_ID = "org.eclipse.papyrus.documentation.view.DocView";
    private ISelection bootstrapSelection;

    protected IPage createDefaultPage(PageBook book) {
        EmptyDocPage page = new EmptyDocPage();
        this.initPage(page);
        page.createControl((Composite)book);
        return page;
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        IDocPage page = (IDocPage)part.getAdapter(IDocPage.class);
        if (page == null) {
            page = (IDocPage)Platform.getAdapterManager().loadAdapter((Object)part, IDocPage.class.getName());
        }
        if (page == null && DocumentionPartHandlerRegistry.getInstance().getDocumentationPartHandler(part) != null) {
            page = new DocPage();
        }
        if (page != null) {
            this.initPage(page);
            page.createControl((Composite)this.getPageBook());
            return new PageBookView.PageRec(part, (IPage)page);
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec rec) {
        IDocPage page = (IDocPage)rec.page;
        page.dispose();
        rec.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            this.bootstrapSelection = page.getSelection();
            return page.getActivePart();
        }
        return null;
    }

    public void init(IViewSite site) throws PartInitException {
        site.getPage().addSelectionListener((ISelectionListener)this);
        super.init(site);
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IEditorPart || part instanceof IViewPart;
    }

    public void partActivated(IWorkbenchPart part) {
        IContributedContentsView view = (IContributedContentsView)part.getAdapter(IContributedContentsView.class);
        IWorkbenchPart source = null;
        if (view != null) {
            source = view.getContributingPart();
        }
        if (source != null) {
            super.partActivated(source);
        } else {
            super.partActivated(part);
        }
        if (this.bootstrapSelection != null) {
            IDocPage page = (IDocPage)this.getCurrentPage();
            if (page != null) {
                page.selectionChanged(part, this.bootstrapSelection);
            }
            this.bootstrapSelection = null;
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        IDocPage page;
        if ((part instanceof IEditorPart || part instanceof ContentOutline || part instanceof IViewPart && !(part instanceof DocView)) && (page = (IDocPage)this.getCurrentPage()) != null) {
            page.selectionChanged(part, sel);
        }
    }

    private IWorkbenchPart getContributingEditor() {
        return this.getCurrentContributingPart();
    }

    public Object getAdapter(Class key) {
        if (key == IContributedContentsView.class) {
            return new IContributedContentsView(){

                public IWorkbenchPart getContributingPart() {
                    return DocView.this.getContributingEditor();
                }
            };
        }
        return super.getAdapter(key);
    }
}

