/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.view;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.documentation.IDocumentationChangedListener;
import org.eclipse.papyrus.documentation.view.IDocumentationPartHandler;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentionPartHandlerRegistry {
    private static final String DOCUMENTATIONPARTHANDLER_EXTENSION_ID = "org.eclipse.papyrus.documentation.view.documentationPartHandler";
    private static final String DOCUMENTATIONPARTHANDLER_ID = "documentationPartHandler";
    private Set<IDocumentationPartHandler> documentationPartHandlers = new HashSet<IDocumentationPartHandler>();
    private Set<IDocumentationChangedListener> documentationChangedListeners = new HashSet<IDocumentationChangedListener>();

    public static DocumentionPartHandlerRegistry getInstance() {
        return DocumentionPartHandlerRegistryHolder.instance;
    }

    private DocumentionPartHandlerRegistry() {
        this.initializeMap();
    }

    public IDocumentationPartHandler getDocumentationPartHandler(IWorkbenchPart part) {
        for (IDocumentationPartHandler documentationPartHandler : this.documentationPartHandlers) {
            if (!documentationPartHandler.canHandlePart(part)) continue;
            return documentationPartHandler;
        }
        return null;
    }

    private void initializeMap() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(DOCUMENTATIONPARTHANDLER_EXTENSION_ID);
        int i = 0;
        while (i < configElements.length) {
            this.initializeOne(configElements[i]);
            ++i;
        }
    }

    private void initializeOne(IConfigurationElement iConfigurationElement) {
        try {
            IDocumentationPartHandler documentationPartHandler = (IDocumentationPartHandler)iConfigurationElement.createExecutableExtension(DOCUMENTATIONPARTHANDLER_ID);
            this.documentationPartHandlers.add(documentationPartHandler);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void registerDocumentationChangedListener(IDocumentationChangedListener listener) {
        this.documentationChangedListeners.add(listener);
    }

    public void unregisterDocumentationChangedListener(IDocumentationChangedListener listener) {
        this.documentationChangedListeners.remove(listener);
    }

    public Set<IDocumentationChangedListener> getRegisteredDocumentationChangedListeners() {
        return this.documentationChangedListeners;
    }

    /* synthetic */ DocumentionPartHandlerRegistry(DocumentionPartHandlerRegistry documentionPartHandlerRegistry) {
        this();
    }

    private static class DocumentionPartHandlerRegistryHolder {
        public static final DocumentionPartHandlerRegistry instance = new DocumentionPartHandlerRegistry(null);

        private DocumentionPartHandlerRegistryHolder() {
        }
    }
}

