/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.view;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.documentation.DocumentationUnsupportedException;
import org.eclipse.papyrus.documentation.IDocumentationManager;
import org.eclipse.papyrus.documentation.view.ArrayTreeContentProvider;
import org.eclipse.papyrus.documentation.view.DocPageComposite;
import org.eclipse.papyrus.documentation.view.DocViewPlugin;
import org.eclipse.papyrus.documentation.view.DocumentionPartHandlerRegistry;
import org.eclipse.papyrus.documentation.view.ExternalResourceEditorInput;
import org.eclipse.papyrus.documentation.view.IDocumentationPartHandler;
import org.eclipse.papyrus.documentation.view.Messages;
import org.eclipse.papyrus.documentation.view.TypedResourcesSelectionDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourcesComposite
extends DocPageComposite {
    private TreeViewer resourcesList;
    private Button addResourcesButton;
    private Button removeResourcesButton;
    private Button editResourceButton;
    private ISelectionChangedListener selectionChangedListener;
    private SelectionListener buttonSelectionListener;
    private IDoubleClickListener listDoubleClickListener;
    private KeyListener listKeyListener;

    public ResourcesComposite(Composite parent, int style) {
        super(parent, style);
    }

    protected void createContents(Composite parent) {
        this.selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResourcesComposite.this.handleResourcesListSelectionChanged();
            }
        };
        this.buttonSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == ResourcesComposite.this.addResourcesButton) {
                    ResourcesComposite.this.handleAddResources();
                } else if (e.getSource() == ResourcesComposite.this.removeResourcesButton) {
                    ResourcesComposite.this.handleRemoveResources();
                } else if (e.getSource() == ResourcesComposite.this.editResourceButton) {
                    ResourcesComposite.this.handleEditResource();
                }
            }
        };
        this.listDoubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ResourcesComposite.this.handleOpenResource();
            }
        };
        this.listKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    ResourcesComposite.this.handleRemoveResources();
                }
            }
        };
        this.resourcesList = new TreeViewer(parent, 2562);
        this.resourcesList.getTree().setLayoutData((Object)new GridData(1808));
        this.resourcesList.setContentProvider((IContentProvider)new ArrayTreeContentProvider());
        this.resourcesList.setLabelProvider((IBaseLabelProvider)new ResourcesLabelProvider());
        this.resourcesList.addSelectionChangedListener(this.selectionChangedListener);
        this.resourcesList.addDoubleClickListener(this.listDoubleClickListener);
        this.resourcesList.getTree().addKeyListener(this.listKeyListener);
        Composite actionsComp = new Composite(parent, 0);
        actionsComp.setLayout((Layout)new GridLayout(3, true));
        actionsComp.setLayoutData((Object)new GridData(64));
        this.addResourcesButton = new Button(actionsComp, 8);
        this.addResourcesButton.setText(Messages.ResourcesComposite_add);
        this.addResourcesButton.setLayoutData((Object)new GridData(1808));
        this.addResourcesButton.addSelectionListener(this.buttonSelectionListener);
        this.removeResourcesButton = new Button(actionsComp, 8);
        this.removeResourcesButton.setText(Messages.ResourcesComposite_remove);
        this.removeResourcesButton.setLayoutData((Object)new GridData(1808));
        this.removeResourcesButton.addSelectionListener(this.buttonSelectionListener);
        this.editResourceButton = new Button(actionsComp, 8);
        this.editResourceButton.setText(Messages.ResourcesComposite_edit);
        this.editResourceButton.setLayoutData((Object)new GridData(1808));
        this.editResourceButton.addSelectionListener(this.buttonSelectionListener);
    }

    protected void refresh() {
        this.resourcesList.setInput(null);
        this.resourcesList.getTree().setEnabled(this.getDocumentedElement() != null);
        this.addResourcesButton.setEnabled(this.getDocumentedElement() != null);
        this.removeResourcesButton.setEnabled(false);
        this.editResourceButton.setEnabled(false);
        if (this.getDocumentedElement() != null) {
            IWorkbenchPart activePart = this.getActivePart();
            IDocumentationPartHandler documentationPartHandler = DocumentionPartHandlerRegistry.getInstance().getDocumentationPartHandler(activePart);
            if (documentationPartHandler != null) {
                try {
                    EObject associatedDiagram = documentationPartHandler.getAssociatedDiagram(activePart, this.getDocumentedElement());
                    EObject toDocument = associatedDiagram == null ? this.getDocumentedElement() : associatedDiagram;
                    List resources = documentationPartHandler.getDocumentationManager().getAssociatedResources(toDocument);
                    this.resourcesList.setInput((Object)resources);
                }
                catch (DocumentationUnsupportedException documentationUnsupportedException) {
                    // empty catch block
                }
            }
        }
    }

    protected IDocumentationPartHandler getDocumentationPartHandler(IWorkbenchPart part) {
        if (this.getDocumentedElement() != null) {
            return DocumentionPartHandlerRegistry.getInstance().getDocumentationPartHandler(part);
        }
        return null;
    }

    protected Command getAddAssociatedResourceCommand(URI uriResource) {
        IDocumentationPartHandler documentationPartHandler = this.getDocumentationPartHandler(this.getActivePart());
        if (documentationPartHandler != null) {
            EObject associatedDiagram = documentationPartHandler.getAssociatedDiagram(this.getActivePart(), this.getDocumentedElement());
            EObject toDocument = associatedDiagram == null ? this.getDocumentedElement() : associatedDiagram;
            IDocumentationManager documentationManager = documentationPartHandler.getDocumentationManager();
            if (documentationManager != null) {
                return documentationManager.getAddAssociatedResourceCommand(toDocument, uriResource);
            }
        }
        return null;
    }

    protected Command getRemoveAssociatedResourceCommand(URI uriResource) {
        IDocumentationPartHandler documentationPartHandler = this.getDocumentationPartHandler(this.getActivePart());
        if (documentationPartHandler != null) {
            EObject associatedDiagram = documentationPartHandler.getAssociatedDiagram(this.getActivePart(), this.getDocumentedElement());
            EObject toDocument = associatedDiagram == null ? this.getDocumentedElement() : associatedDiagram;
            IDocumentationManager documentationManager = documentationPartHandler.getDocumentationManager();
            if (documentationManager != null) {
                return documentationManager.getRemoveAssociatedResourceCommand(toDocument, uriResource);
            }
        }
        return null;
    }

    private void executeCommand(CompoundCommand compoundCmd) {
        IWorkbenchPart part = this.getActivePart();
        if (this.getDocumentationPartHandler(part) != null) {
            this.getDocumentationPartHandler(part).executeCommand(part, (Command)compoundCmd);
        }
    }

    private void handleResourcesListSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.resourcesList.getSelection();
        this.removeResourcesButton.setEnabled(!selection.isEmpty());
        this.editResourceButton.setEnabled(selection.size() == 1);
    }

    private void handleAddResources() {
        if (this.getDocumentedElement() != null) {
            HashSet<URI> resourcesToAdd = new HashSet<URI>();
            TypedResourcesSelectionDialog dialog = new TypedResourcesSelectionDialog(this.getShell());
            int result = dialog.open();
            if (result == 0) {
                switch (dialog.getType()) {
                    case 2: {
                        RemoteResourceDialog rrDialog = new RemoteResourceDialog(this.getShell(), "http://");
                        if (rrDialog.open() != 0) break;
                        resourcesToAdd.add(URI.createURI((String)rrDialog.getValue()));
                        break;
                    }
                    case 1: {
                        FileDialog erDialog = new FileDialog(this.getShell(), 2);
                        if (erDialog.open() == null) break;
                        String[] resources = erDialog.getFileNames();
                        int i = 0;
                        while (i < resources.length) {
                            resourcesToAdd.add(URI.createFileURI((String)(String.valueOf(erDialog.getFilterPath()) + File.separator + resources[i])));
                            ++i;
                        }
                        break;
                    }
                    default: {
                        WorkspaceResourceDialog wrDialog = new WorkspaceResourceDialog(this.getShell());
                        result = wrDialog.open();
                        if (result != 0) break;
                        Object[] resources = wrDialog.getResult();
                        int i = 0;
                        while (i < resources.length) {
                            if (resources[i] instanceof IFile) {
                                resourcesToAdd.add(URI.createPlatformResourceURI((String)((IFile)resources[i]).getFullPath().toString(), (boolean)true));
                            }
                            ++i;
                        }
                        break block0;
                    }
                }
                CompoundCommand compoundCmd = new CompoundCommand();
                for (URI uriResource : resourcesToAdd) {
                    compoundCmd.appendIfCanExecute(this.getAddAssociatedResourceCommand(uriResource));
                }
                this.executeCommand(compoundCmd);
            }
        }
    }

    private void handleRemoveResources() {
        IStructuredSelection selection;
        List resourcesToRemove;
        if (this.getDocumentedElement() != null && !(resourcesToRemove = (selection = (IStructuredSelection)this.resourcesList.getSelection()).toList()).isEmpty() && MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.ResourcesComposite_resourcesRemoving, (String)Messages.ResourcesComposite_deleteResourcesConfirmation)) {
            CompoundCommand compoundCmd = new CompoundCommand();
            for (URI uriResource : resourcesToRemove) {
                compoundCmd.appendIfCanExecute(this.getRemoveAssociatedResourceCommand(uriResource));
            }
            this.executeCommand(compoundCmd);
        }
    }

    private void handleEditResource() {
        IStructuredSelection selection = (IStructuredSelection)this.resourcesList.getSelection();
        if (selection.size() == 1) {
            URI uri = (URI)selection.getFirstElement();
            URI newUri = null;
            if (uri != null) {
                if (uri.isPlatform()) {
                    WorkspaceResourceDialog wrDialog = new WorkspaceResourceDialog(this.getShell());
                    wrDialog.setInitialSelections(new IFile[]{ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)))});
                    if (wrDialog.open() == 0) {
                        newUri = URI.createPlatformResourceURI((String)((IFile)wrDialog.getResult()[0]).getFullPath().toString(), (boolean)true);
                    }
                } else if (uri.isFile()) {
                    FileDialog erDialog = new FileDialog(this.getShell());
                    erDialog.setFileName(uri.toFileString());
                    newUri = URI.createFileURI((String)erDialog.open());
                } else {
                    RemoteResourceDialog rrDialog = new RemoteResourceDialog(this.getShell(), uri.toString());
                    if (rrDialog.open() == 0) {
                        newUri = URI.createURI((String)rrDialog.getValue());
                    }
                }
                if (newUri != null) {
                    CompoundCommand compoundCmd = new CompoundCommand();
                    compoundCmd.appendIfCanExecute(this.getRemoveAssociatedResourceCommand(uri));
                    compoundCmd.appendIfCanExecute(this.getAddAssociatedResourceCommand(uri));
                    this.executeCommand(compoundCmd);
                }
            }
        }
    }

    private void handleOpenResource() {
        IStructuredSelection selection = (IStructuredSelection)this.resourcesList.getSelection();
        if (selection.size() == 1) {
            URI uri = (URI)selection.getFirstElement();
            if (uri.isPlatform()) {
                String platformString = uri.toPlatformString(true);
                IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformString));
                try {
                    IDE.openEditor((IWorkbenchPage)DocViewPlugin.getActivePage(), (IFile)resource);
                }
                catch (PartInitException pie) {
                    this.displayErrorDialog("Invalid workspace resource", "The workspace resource '" + platformString + "' cannot be opened.");
                }
            } else if (uri.isFile()) {
                String fileString = uri.toFileString();
                File resource = new File(fileString);
                ExternalResourceEditorInput input = new ExternalResourceEditorInput(resource);
                try {
                    IDE.openEditor((IWorkbenchPage)DocViewPlugin.getActivePage(), (IEditorInput)input, (String)this.getEditorId(resource));
                }
                catch (PartInitException pie) {
                    this.displayErrorDialog("Invalid external resource", "The external resource '" + fileString + "' cannot be opened.");
                }
            } else {
                String remoteString = uri.toString();
                try {
                    DocViewPlugin.openURL(new URL(remoteString));
                }
                catch (MalformedURLException e) {
                    this.displayErrorDialog("Invalid remote resource", "The remote resource '" + remoteString + "' cannot be opened.");
                }
            }
        }
    }

    private void displayErrorDialog(final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)ResourcesComposite.this.getShell(), (String)(title == null ? "Error" : title), (String)(message == null ? "" : message));
            }
        });
    }

    private String getEditorId(File file) {
        IWorkbench workbench = DocViewPlugin.getDefault().getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName(), this.getContentType(file));
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.resourcesList != null && this.resourcesList.getControl() != null) {
            this.resourcesList.getControl().setEnabled(enabled);
        }
        if (this.editResourceButton != null) {
            this.editResourceButton.setEnabled(enabled);
        }
        if (this.removeResourcesButton != null) {
            this.removeResourcesButton.setEnabled(enabled);
        }
        if (this.addResourcesButton != null) {
            this.addResourcesButton.setEnabled(enabled);
        }
    }

    /*
     * Loose catch block
     */
    private IContentType getContentType(File file) {
        if (file == null) {
            return null;
        }
        FileInputStream stream = null;
        stream = new FileInputStream(file);
        IContentType iContentType = Platform.getContentTypeManager().findContentTypeFor((InputStream)stream, file.getName());
        try {
            if (stream != null) {
                ((InputStream)stream).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return iContentType;
        catch (IOException x) {
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private class RemoteResourceDialog
    extends InputDialog {
        public RemoteResourceDialog(Shell parentShell, String initialValue) {
            super(parentShell, "Remote resource", "Please enter the URL of the remote resource.", initialValue, null);
        }
    }

    private class ResourcesLabelProvider
    extends LabelProvider {
        private WorkbenchLabelProvider wlp = new WorkbenchLabelProvider();

        private ResourcesLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof URI) {
                URI uri = (URI)element;
                if (uri.isPlatform()) {
                    return uri.toPlatformString(true);
                }
                if (uri.isFile()) {
                    return uri.toFileString();
                }
                return uri.toString();
            }
            return "Unknown resource";
        }

        public Image getImage(Object element) {
            if (element instanceof URI) {
                URI uri = (URI)element;
                if (uri.isPlatform()) {
                    IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
                    return this.wlp.getImage((Object)iFile);
                }
                if (uri.isFile()) {
                    return DocViewPlugin.getDefault().getImageRegistry().get("EXTERNAL_RESOURCE");
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
            return null;
        }
    }

    private class WorkspaceResourceDialog
    extends ResourceSelectionDialog {
        public WorkspaceResourceDialog(Shell parentShell) {
            super(parentShell, (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), "Please select the workspace resources to add to the documentation.");
        }
    }
}

