/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.view;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.emf.common.util.URI;
import org.eclipse.epf.richtext.RichText;
import org.eclipse.papyrus.documentation.view.DocViewPlugin;
import org.eclipse.papyrus.documentation.view.DocumentionPartHandlerRegistry;
import org.eclipse.papyrus.documentation.view.IDocumentationPartHandler;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class RichTextComposite
extends Composite {
    private RichText commentsText;

    public RichTextComposite(Composite parent, int style) {
        super(parent, style);
        Composite container = new Composite((Composite)this, 2048);
        GridLayout richTextLayout = new GridLayout();
        richTextLayout.marginWidth = 0;
        richTextLayout.marginHeight = 0;
        container.setLayout((Layout)richTextLayout);
        container.setLayoutData((Object)new GridData(1808));
        this.commentsText = new RichText(container, 0);
        this.commentsText.setEditable(false);
        this.commentsText.setLayoutData((Object)new GridData(1808));
        Browser browser = (Browser)this.commentsText.getControl();
        browser.addLocationListener((LocationListener)new URLLocationListener());
    }

    public String getDocumentationValue() {
        return this.commentsText.getText();
    }

    public void setDocumentationValue(String text) {
        this.commentsText.setText(text);
    }

    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            super.setEnabled(enabled);
            if (this.commentsText != null && this.commentsText.getControl() != null) {
                this.commentsText.getControl().setEnabled(enabled);
            }
        }
    }

    private static class URLLocationListener
    extends LocationAdapter {
        private URLLocationListener() {
        }

        public void changing(LocationEvent event) {
            String url = event.location;
            if (url == null) {
                return;
            }
            URLParser parser = new URLParser(url);
            if (parser.isValidURI()) {
                event.doit = false;
                parser.runURL();
            }
        }
    }

    private static class URLParser {
        private static final String HTTP_PROTOCOL = "http";
        private static final String PLATFORM_PROTOCOL = "platform";
        private URI uri;

        private URLParser(String url) {
            this.parseUrl(url);
        }

        private void parseUrl(String url) {
            if (url == null) {
                return;
            }
            this.uri = null;
            try {
                URL url_inst = new URL(url);
                String protocol2 = url_inst.getProtocol();
                if (protocol2 != null) {
                    if (protocol2.equalsIgnoreCase(HTTP_PROTOCOL)) {
                        this.uri = URI.createURI((String)URI.decode((String)url.replace("http://platform", "platform:").replace("platform::/", "platform:/")));
                    } else if (protocol2.equalsIgnoreCase(PLATFORM_PROTOCOL)) {
                        this.uri = URI.createURI((String)URI.decode((String)url));
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }

        private boolean isValidURI() {
            return this.uri != null;
        }

        private void runURL() {
            Display display = Display.getCurrent();
            BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                public void run() {
                    IEditorPart activeEditor = DocViewPlugin.getActiveEditor();
                    IDocumentationPartHandler documentationEditor = DocumentionPartHandlerRegistry.getInstance().getDocumentationPartHandler((IWorkbenchPart)activeEditor);
                    if (documentationEditor != null) {
                        documentationEditor.openElement((IWorkbenchPart)activeEditor, URLParser.this.uri);
                    }
                }
            });
        }
    }
}

