/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.view;

import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.IRichTextToolBar;
import org.eclipse.epf.richtext.RichText;
import org.eclipse.epf.richtext.RichTextToolBar;
import org.eclipse.epf.richtext.actions.AddImageAction;
import org.eclipse.epf.richtext.actions.AddLinkAction;
import org.eclipse.epf.richtext.actions.AddOrderedListAction;
import org.eclipse.epf.richtext.actions.AddTableAction;
import org.eclipse.epf.richtext.actions.AddUnorderedListAction;
import org.eclipse.epf.richtext.actions.BoldAction;
import org.eclipse.epf.richtext.actions.ClearContentAction;
import org.eclipse.epf.richtext.actions.CopyAction;
import org.eclipse.epf.richtext.actions.CutAction;
import org.eclipse.epf.richtext.actions.FindReplaceAction;
import org.eclipse.epf.richtext.actions.FontNameAction;
import org.eclipse.epf.richtext.actions.FontSizeAction;
import org.eclipse.epf.richtext.actions.FontStyleAction;
import org.eclipse.epf.richtext.actions.IndentAction;
import org.eclipse.epf.richtext.actions.ItalicAction;
import org.eclipse.epf.richtext.actions.JustifyCenterAction;
import org.eclipse.epf.richtext.actions.JustifyLeftAction;
import org.eclipse.epf.richtext.actions.JustifyRightAction;
import org.eclipse.epf.richtext.actions.OutdentAction;
import org.eclipse.epf.richtext.actions.PasteAction;
import org.eclipse.epf.richtext.actions.RichTextComboAction;
import org.eclipse.epf.richtext.actions.SubscriptAction;
import org.eclipse.epf.richtext.actions.SuperscriptAction;
import org.eclipse.epf.richtext.actions.TidyActionGroup;
import org.eclipse.epf.richtext.actions.UnderlineAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.papyrus.documentation.view.Messages;
import org.eclipse.papyrus.documentation.view.actions.AddElementLinkAction;
import org.eclipse.papyrus.documentation.view.actions.DeleteTableColumnAction;
import org.eclipse.papyrus.documentation.view.actions.DeleteTableRowAction;
import org.eclipse.papyrus.documentation.view.actions.InsertTableColumnAction;
import org.eclipse.papyrus.documentation.view.actions.InsertTableRowAction;
import org.eclipse.papyrus.documentation.view.actions.TextColorAction;
import org.eclipse.papyrus.documentation.view.actions.TextHighlightAction;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RichTextEditorDialog
extends Dialog {
    private static final int MINIMUM_DIALOG_WIDTH = 600;
    private static final int MINIMUM_DIALOG_HEIGHT = 300;
    private RichText commentsText;
    private String initialValue;
    private String newValue;

    public RichTextEditorDialog(Shell parentShell, String initialValue) {
        super(parentShell);
        this.setBlockOnOpen(true);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.initialValue = initialValue;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.RichTextEditorDialog_useRichText);
        newShell.setMinimumSize(600, 300);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = (Composite)super.createDialogArea(parent);
        RichTextToolBar toolBar = new RichTextToolBar(dialogComposite, 0, (IRichText)this.commentsText);
        Composite container = new Composite(dialogComposite, 2048);
        GridLayout richTextLayout = new GridLayout();
        richTextLayout.marginWidth = 0;
        richTextLayout.marginHeight = 0;
        container.setLayout((Layout)richTextLayout);
        container.setLayoutData((Object)new GridData(1808));
        this.commentsText = new RichText(container, 0);
        this.commentsText.setLayoutData((Object)new GridData(1808));
        this.commentsText.setText(this.initialValue);
        this.commentsText.setFocus();
        this.fillToolBar((IRichTextToolBar)toolBar, (IRichText)this.commentsText);
        return dialogComposite;
    }

    private void fillToolBar(IRichTextToolBar toolBar, IRichText richText) {
        toolBar.addAction((RichTextComboAction)new FontStyleAction(richText));
        toolBar.addAction((RichTextComboAction)new FontNameAction(richText));
        toolBar.addAction((RichTextComboAction)new FontSizeAction(richText));
        toolBar.addSeparator();
        toolBar.addAction((IAction)new CutAction(richText));
        toolBar.addAction((IAction)new CopyAction(richText));
        toolBar.addAction((IAction)new PasteAction(richText));
        toolBar.addSeparator();
        toolBar.addAction((IAction)new ClearContentAction(richText));
        toolBar.addSeparator();
        toolBar.addAction((IAction)new BoldAction(richText));
        toolBar.addAction((IAction)new ItalicAction(richText));
        toolBar.addAction((IAction)new UnderlineAction(richText));
        toolBar.addSeparator();
        toolBar.addAction((IAction)new TextColorAction(richText));
        toolBar.addAction((IAction)new TextHighlightAction(richText));
        toolBar.addSeparator();
        toolBar.addAction((IAction)new SubscriptAction(richText));
        toolBar.addAction((IAction)new SuperscriptAction(richText));
        toolBar.addSeparator();
        toolBar.addAction((IAction)new TidyActionGroup(richText));
        toolBar.addSeparator();
        toolBar.addAction((IAction)new AddOrderedListAction(richText));
        toolBar.addAction((IAction)new AddUnorderedListAction(richText));
        toolBar.addSeparator();
        toolBar.addAction((IAction)new OutdentAction(richText));
        toolBar.addAction((IAction)new IndentAction(richText));
        toolBar.addSeparator();
        toolBar.addAction((IAction)new JustifyLeftAction(richText));
        toolBar.addAction((IAction)new JustifyCenterAction(richText));
        toolBar.addAction((IAction)new JustifyRightAction(richText));
        toolBar.addSeparator();
        toolBar.addAction((IAction)new FindReplaceAction(richText){

            public void execute(IRichText rText) {
                rText.getFindReplaceAction().execute(rText);
            }
        });
        toolBar.addSeparator();
        toolBar.addAction((IAction)new AddLinkAction(richText));
        toolBar.addAction((IAction)new AddElementLinkAction(richText));
        toolBar.addAction((IAction)new AddImageAction(richText));
        toolBar.addSeparator();
        toolBar.addAction((IAction)new AddTableAction(richText));
        if (Platform.getOS().equals("win32")) {
            toolBar.addAction((IAction)new InsertTableColumnAction(richText));
            toolBar.addAction((IAction)new DeleteTableColumnAction(richText));
            toolBar.addAction((IAction)new InsertTableRowAction(richText));
            toolBar.addAction((IAction)new DeleteTableRowAction(richText));
        }
    }

    protected void okPressed() {
        this.newValue = this.commentsText.getText();
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public String getDocumentationValue() {
        return this.newValue;
    }
}

