/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.view;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.navigator.ResourceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectResourceDialog
extends ElementTreeSelectionDialog {
    private boolean hasFilteredTree = true;

    public static Object openElementSelection(Object input, ISelectionStatusValidator validator, List<ViewerFilter> viewerFilters, boolean filterTree) {
        return SelectResourceDialog.openElementSelection(input, null, null, validator, viewerFilters, filterTree);
    }

    public static Object openElementSelection(Object input, ILabelProvider labelProvider, ITreeContentProvider contentProvider, ISelectionStatusValidator validator, List<ViewerFilter> viewerFilters, boolean filterTree) {
        if (contentProvider == null) {
            contentProvider = new SelectionContentProvider();
        }
        if (labelProvider == null) {
            labelProvider = new SelectionLabelProvider();
        }
        Shell parent = Display.getCurrent().getActiveShell();
        SelectResourceDialog dialog = new SelectResourceDialog(parent, validator, labelProvider, contentProvider, filterTree);
        dialog.setAllowMultiple(false);
        dialog.setTitle("Import from model");
        dialog.setMessage("Select the element to import\nWARNING: Stereotypes will not be retrieved from the import model");
        dialog.addFilter(dialog.createDefaultViewerFilter(true));
        if (viewerFilters != null) {
            for (ViewerFilter viewerFilter : viewerFilters) {
                dialog.addFilter(viewerFilter);
            }
        }
        dialog.setInput(input);
        return dialog.open() == 0 ? dialog.getSelection() : null;
    }

    private SelectResourceDialog(Shell parent, ISelectionStatusValidator validator, ILabelProvider labelProvider, ITreeContentProvider contentProvider, boolean hasFilteredTree) {
        super(parent, labelProvider, contentProvider);
        this.setComparator((ViewerComparator)new ResourceComparator(1));
        this.setValidator(validator);
        this.hasFilteredTree = hasFilteredTree;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        SelectResourceDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        TreeViewer viewer;
        if (this.hasFilteredTree) {
            FilteredTree tree = new FilteredTree(parent, style, new PatternFilter(), true);
            viewer = tree.getViewer();
        } else {
            viewer = new TreeViewer(parent, style);
        }
        return viewer;
    }

    public Object getSelection() {
        Object[] result = this.getResult();
        if (result.length == 1) {
            return result[0];
        }
        return null;
    }

    private ViewerFilter createDefaultViewerFilter(boolean showFiles) {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IResource) {
                    IResource workspaceResource = (IResource)element;
                    return workspaceResource.isAccessible();
                }
                return true;
            }
        };
    }

    public static class SelectionContentProvider
    implements ITreeContentProvider,
    IResourceChangeListener,
    IResourceDeltaVisitor {
        private WorkbenchContentProvider resourceContentProvider = new WorkbenchContentProvider();
        private AdapterFactoryContentProvider adapterFactoryContentProvider = new AdapterFactoryContentProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        private ResourceSet resourceSet = new ResourceSetImpl();
        private Viewer viewer;

        public SelectionContentProvider() {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }

        public Object[] getChildren(Object parentElement) {
            try {
                if (parentElement instanceof IFile) {
                    String path = ((IFile)parentElement).getFullPath().toString();
                    URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
                    parentElement = this.resourceSet.getResource(uri, true);
                }
                if (parentElement instanceof IResource) {
                    return this.resourceContentProvider.getChildren(parentElement);
                }
            }
            catch (Exception e) {
                return new Object[0];
            }
            return this.adapterFactoryContentProvider.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            if (element instanceof IResource) {
                return this.resourceContentProvider.getParent(element);
            }
            return this.adapterFactoryContentProvider.getParent(element);
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IFile) {
                return ((IFile)element).isAccessible() && !((IFile)element).isHidden();
            }
            if (element instanceof IResource) {
                return this.resourceContentProvider.hasChildren(element);
            }
            return this.adapterFactoryContentProvider.hasChildren(element);
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = viewer;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }

        public void dispose() {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this.resourceContentProvider.dispose();
            this.adapterFactoryContentProvider.dispose();
        }

        public boolean visit(IResourceDelta delta) {
            IResource source = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    if (!(source instanceof IFile)) break;
                    final IFile file = (IFile)source;
                    Resource oldResource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), false);
                    if (oldResource != null) {
                        oldResource.unload();
                    }
                    new UIJob("Update the Model in TopcasedViewer"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (SelectionContentProvider.this.viewer != null && !SelectionContentProvider.this.viewer.getControl().isDisposed()) {
                                ((StructuredViewer)SelectionContentProvider.this.viewer).refresh((Object)file);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
            return true;
        }
    }

    private static class SelectionLabelProvider
    implements ILabelProvider {
        private WorkbenchLabelProvider resourceLabelProvider = new WorkbenchLabelProvider();
        private AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));

        private SelectionLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IResource) {
                return this.resourceLabelProvider.getImage(element);
            }
            return this.adapterFactoryLabelProvider.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IResource) {
                return this.resourceLabelProvider.getText(element);
            }
            return this.adapterFactoryLabelProvider.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
            this.resourceLabelProvider.addListener(listener);
            this.adapterFactoryLabelProvider.addListener(listener);
        }

        public void dispose() {
            this.resourceLabelProvider.dispose();
            this.adapterFactoryLabelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            if (element instanceof IResource) {
                return this.resourceLabelProvider.isLabelProperty(element, property);
            }
            return this.adapterFactoryLabelProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.resourceLabelProvider.removeListener(listener);
            this.adapterFactoryLabelProvider.removeListener(listener);
        }
    }
}

