/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.view;

import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.documentation.view.IText;
import org.eclipse.papyrus.documentation.view.Messages;
import org.eclipse.papyrus.documentation.view.TextViewerAction;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class SpellingTextComposite
extends Composite
implements IText,
Observer {
    protected StyledText fTextField;
    protected SourceViewer sourceViewer;
    protected Document document;
    protected static final String CURRENT_LINE = "currentLine";
    protected static final String CURRENT_LINE_COLOR = "currentLineColor";
    private IHandlerActivation quickFixhandlerActivation;

    public SpellingTextComposite(Composite composite) {
        this(composite, 770, false);
    }

    public SpellingTextComposite(Composite composite, int style) {
        this(composite, style, false);
    }

    public SpellingTextComposite(Composite composite, int style, boolean colored) {
        super(composite, 2048);
        this.setLayout((Layout)new FillLayout());
        AnnotationModel annotationModel = new AnnotationModel();
        DefaultMarkerAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
        this.sourceViewer = new SourceViewer((Composite)this, null, null, true, style);
        this.fTextField = this.sourceViewer.getTextWidget();
        final SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)this.sourceViewer, null, (IAnnotationAccess)annotationAccess, EditorsUI.getSharedTextColors());
        if (colored) {
            support.setCursorLinePainterPreferenceKeys(CURRENT_LINE, CURRENT_LINE_COLOR);
        }
        Iterator e = new MarkerAnnotationPreferences().getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
        support.install(EditorsUI.getPreferenceStore());
        final IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        final ActionHandler quickFixActionHandler = this.createQuickFixActionHandler((ITextOperationTarget)this.sourceViewer);
        final TextViewerAction cutAction = new TextViewerAction((ITextViewer)this.sourceViewer, 3);
        cutAction.setText(Messages.SpellingTextComposite_cut);
        cutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        final TextViewerAction copyAction = new TextViewerAction((ITextViewer)this.sourceViewer, 4);
        copyAction.setText(Messages.SpellingTextComposite_copy);
        copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        final TextViewerAction pasteAction = new TextViewerAction((ITextViewer)this.sourceViewer, 5);
        pasteAction.setText(Messages.SpellingTextComposite_paste);
        pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        final TextViewerAction selectAllAction = new TextViewerAction((ITextViewer)this.sourceViewer, 7);
        selectAllAction.setText(Messages.SpellingTextComposite_selectAll);
        selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        MenuManager contextMenu = new MenuManager();
        contextMenu.add((IAction)cutAction);
        contextMenu.add((IAction)copyAction);
        contextMenu.add((IAction)pasteAction);
        contextMenu.add((IAction)selectAllAction);
        contextMenu.add((IContributionItem)new Separator());
        final SubMenuManager quickFixMenu = new SubMenuManager((IMenuManager)contextMenu);
        quickFixMenu.setVisible(true);
        quickFixMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                quickFixMenu.removeAll();
                if (SpellingTextComposite.this.fTextField != null && SpellingTextComposite.this.fTextField.getEditable()) {
                    IAnnotationModel annotationModel = SpellingTextComposite.this.sourceViewer.getAnnotationModel();
                    Iterator annotationIterator = annotationModel.getAnnotationIterator();
                    while (annotationIterator.hasNext()) {
                        Annotation annotation = (Annotation)annotationIterator.next();
                        if (annotation.isMarkedDeleted() || !SpellingTextComposite.this.includes(annotationModel.getPosition(annotation), SpellingTextComposite.this.sourceViewer.getTextWidget().getCaretOffset()) || !SpellingTextComposite.this.sourceViewer.getQuickAssistAssistant().canFix(annotation)) continue;
                        ICompletionProposal[] computeQuickAssistProposals = SpellingTextComposite.this.sourceViewer.getQuickAssistAssistant().getQuickAssistProcessor().computeQuickAssistProposals(SpellingTextComposite.this.sourceViewer.getQuickAssistInvocationContext());
                        int i = 0;
                        while (i < computeQuickAssistProposals.length) {
                            final ICompletionProposal proposal = computeQuickAssistProposals[i];
                            quickFixMenu.add((IAction)new Action(proposal.getDisplayString()){

                                public void run() {
                                    proposal.apply((this).SpellingTextComposite.this.sourceViewer.getDocument());
                                }

                                public ImageDescriptor getImageDescriptor() {
                                    if (proposal.getImage() != null) {
                                        return ImageDescriptor.createFromImage((Image)proposal.getImage());
                                    }
                                    return null;
                                }
                            });
                            ++i;
                        }
                    }
                }
            }
        });
        this.fTextField.addFocusListener(new FocusListener(){
            private IHandlerActivation cutHandlerActivation;
            private IHandlerActivation copyHandlerActivation;
            private IHandlerActivation pasteHandlerActivation;
            private IHandlerActivation selectAllHandlerActivation;

            public void focusGained(FocusEvent e) {
                cutAction.update();
                copyAction.update();
                IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                this.cutHandlerActivation = service.activateHandler("org.eclipse.ui.edit.cut", (IHandler)new ActionHandler((IAction)cutAction), (Expression)new ActiveShellExpression(SpellingTextComposite.this.getShell()));
                this.copyHandlerActivation = service.activateHandler("org.eclipse.ui.edit.copy", (IHandler)new ActionHandler((IAction)copyAction), (Expression)new ActiveShellExpression(SpellingTextComposite.this.getShell()));
                this.pasteHandlerActivation = service.activateHandler("org.eclipse.ui.edit.paste", (IHandler)new ActionHandler((IAction)pasteAction), (Expression)new ActiveShellExpression(SpellingTextComposite.this.getShell()));
                this.selectAllHandlerActivation = service.activateHandler("org.eclipse.ui.edit.selectAll", (IHandler)new ActionHandler((IAction)selectAllAction), (Expression)new ActiveShellExpression(SpellingTextComposite.this.getShell()));
                SpellingTextComposite.this.quickFixhandlerActivation = SpellingTextComposite.this.installQuickFixActionHandler(handlerService, SpellingTextComposite.this.sourceViewer, (IHandler)quickFixActionHandler);
            }

            public void focusLost(FocusEvent e) {
                IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                if (SpellingTextComposite.this.quickFixhandlerActivation != null) {
                    service.deactivateHandler(SpellingTextComposite.this.quickFixhandlerActivation);
                }
                if (this.cutHandlerActivation != null) {
                    service.deactivateHandler(this.cutHandlerActivation);
                }
                if (this.copyHandlerActivation != null) {
                    service.deactivateHandler(this.copyHandlerActivation);
                }
                if (this.pasteHandlerActivation != null) {
                    service.deactivateHandler(this.pasteHandlerActivation);
                }
                if (this.selectAllHandlerActivation != null) {
                    service.deactivateHandler(this.selectAllHandlerActivation);
                }
            }
        });
        this.sourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                cutAction.update();
                copyAction.update();
            }
        });
        this.sourceViewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                support.uninstall();
                if (SpellingTextComposite.this.quickFixhandlerActivation != null) {
                    handlerService.deactivateHandler(SpellingTextComposite.this.quickFixhandlerActivation);
                }
            }
        });
        this.document = new Document();
        this.sourceViewer.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration(EditorsUI.getPreferenceStore()));
        this.sourceViewer.setDocument((IDocument)this.document, (IAnnotationModel)annotationModel);
        this.fTextField.setMenu(contextMenu.createContextMenu((Control)this.fTextField));
    }

    protected boolean includes(Position position, int caretOffset) {
        return position.includes(caretOffset) || position.offset + position.length == caretOffset;
    }

    public void setBackground(Color object) {
        this.fTextField.setBackground(object);
    }

    public void setForeground(Color color) {
        this.fTextField.setForeground(color);
    }

    private IHandlerActivation installQuickFixActionHandler(IHandlerService handlerService, SourceViewer sourceViewer, IHandler createQuickFixActionHandler) {
        return handlerService.activateHandler("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals", createQuickFixActionHandler, (Expression)AlwaysTrue.INSTANCE);
    }

    private ActionHandler createQuickFixActionHandler(final ITextOperationTarget textOperationTarget) {
        Action quickFixAction = new Action(){

            public void run() {
                textOperationTarget.doOperation(22);
            }
        };
        quickFixAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        return new ActionHandler((IAction)quickFixAction);
    }

    public void setEnabled(boolean enabled) {
        this.fTextField.setEditable(enabled);
        if (!enabled) {
            this.fTextField.setForeground(Display.getDefault().getSystemColor(16));
        } else {
            this.fTextField.setForeground(Display.getDefault().getSystemColor(21));
        }
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof String) {
            this.setText((String)arg);
        }
    }

    public String getText() {
        return this.document.get();
    }

    public Control getControl() {
        return this;
    }

    public Control getTextControl() {
        return this.fTextField;
    }

    public void setEditable(boolean isChangeable) {
        this.fTextField.setEditable(isChangeable);
    }

    public void setText(String string) {
        this.document.set(string);
    }

    private static class AlwaysTrue
    extends Expression {
        public static final AlwaysTrue INSTANCE = new AlwaysTrue();

        private AlwaysTrue() {
        }

        public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
            return EvaluationResult.TRUE;
        }
    }
}

