/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.view;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TypedResourcesSelectionDialog
extends Dialog {
    public static final int WORKSPACE_RESOURCE = 0;
    public static final int EXTERNAL_RESOURCE = 1;
    public static final int REMOTE_RESOURCE = 2;
    private int selectedType = 0;
    private Button workspaceTypeButton;
    private Button externalTypeButton;
    private Button remoteTypeButton;
    private SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == TypedResourcesSelectionDialog.this.remoteTypeButton) {
                TypedResourcesSelectionDialog.this.selectedType = 2;
            } else if (e.getSource() == TypedResourcesSelectionDialog.this.externalTypeButton) {
                TypedResourcesSelectionDialog.this.selectedType = 1;
            } else {
                TypedResourcesSelectionDialog.this.selectedType = 0;
            }
        }
    };

    public TypedResourcesSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Resource type selection");
    }

    public int getType() {
        return this.selectedType;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Label label = new Label(container, 0);
        label.setText("Please choose the type of resource to select.");
        Composite typeComposite = new Composite(container, 0);
        typeComposite.setLayout((Layout)new GridLayout(3, true));
        typeComposite.setLayoutData((Object)new GridData(64));
        this.workspaceTypeButton = new Button(typeComposite, 16);
        this.workspaceTypeButton.setText("Workspace");
        this.workspaceTypeButton.addSelectionListener(this.selectionListener);
        this.workspaceTypeButton.setSelection(true);
        this.externalTypeButton = new Button(typeComposite, 16);
        this.externalTypeButton.setText("External");
        this.externalTypeButton.addSelectionListener(this.selectionListener);
        this.remoteTypeButton = new Button(typeComposite, 16);
        this.remoteTypeButton.setText("Remote");
        this.remoteTypeButton.addSelectionListener(this.selectionListener);
        return container;
    }
}

