/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.view.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.richtext.actions.RichTextAction;
import org.eclipse.papyrus.documentation.view.DocViewPlugin;
import org.eclipse.papyrus.documentation.view.DocumentionPartHandlerRegistry;
import org.eclipse.papyrus.documentation.view.IDocumentationPartHandler;
import org.eclipse.papyrus.documentation.view.Messages;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class AddElementLinkAction
extends RichTextAction {
    public AddElementLinkAction(IRichText richText) {
        super(richText, 1);
        this.setImageDescriptor(DocViewPlugin.getDefault().getImageRegistry().getDescriptor("MODEL_LINK"));
        this.setDisabledImageDescriptor(RichTextImages.DISABLED_IMG_DESC_ADD_LINK);
        this.setToolTipText(Messages.AddElementLinkAction_text);
    }

    public void execute(IRichText richText) {
        String linkURL;
        if (richText != null && (linkURL = this.createURL()) != null && linkURL.length() > 0) {
            richText.executeCommand("addLink", linkURL);
        }
    }

    public boolean disableInSourceMode() {
        return false;
    }

    private String createURL() {
        EObject selection = null;
        IEditorPart activeEditor = DocViewPlugin.getActiveEditor();
        IDocumentationPartHandler documentationPartHandler = DocumentionPartHandlerRegistry.getInstance().getDocumentationPartHandler((IWorkbenchPart)activeEditor);
        if (documentationPartHandler != null) {
            selection = documentationPartHandler.openElementSelectionDialog((IWorkbenchPart)activeEditor);
        }
        if (selection != null) {
            String uri = EcoreUtil.getURI((EObject)selection).toString();
            return "http://" + uri.replace(" ", "%20");
        }
        return null;
    }
}

