/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.view.actions;

import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.actions.RichTextAction;
import org.eclipse.papyrus.documentation.view.DocViewPlugin;
import org.eclipse.papyrus.documentation.view.Messages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Display;

public class TextHighlightAction
extends RichTextAction {
    public TextHighlightAction(IRichText richText) {
        super(richText, 1);
        this.setImageDescriptor(DocViewPlugin.getDefault().getImageRegistry().getDescriptor("TEXT_HIGHLIGHT"));
        this.setToolTipText(Messages.TextHighlightAction_title);
    }

    public void execute(IRichText richText) {
        ColorDialog dialog;
        RGB color;
        if (richText != null && (color = (dialog = new ColorDialog(Display.getCurrent().getActiveShell())).open()) != null) {
            String rgb = "RGB(" + color.red + "," + color.green + "," + color.blue + ")";
            String command = "backColor";
            String platform = SWT.getPlatform();
            if ("motif".equals(platform) || "gtk".equals(platform)) {
                command = "mozillaBackColor";
            }
            richText.executeCommand(command, rgb);
        }
    }
}

