/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.documentation.DocumentationManagerRegistry;
import org.eclipse.papyrus.documentation.DocumentationUnsupportedException;
import org.eclipse.papyrus.documentation.IDocumentationChangedListener;
import org.eclipse.papyrus.documentation.IDocumentationManager;
import org.eclipse.papyrus.documentation.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentationManager
extends DocumentationManagerRegistry
implements IDocumentationManager {
    private static Set<IDocumentationChangedListener> documentationChangedListeners = new HashSet<IDocumentationChangedListener>();

    public static DocumentationManager getInstance() {
        return DocumentationManagerHolder.instance;
    }

    @Override
    public String getDocumentation(EObject eObject) throws DocumentationUnsupportedException {
        IDocumentationManager documentationManager;
        if (eObject != null && (documentationManager = this.getDocumentationManager(eObject.eClass().getEPackage().getNsURI())) != null) {
            return documentationManager.getDocumentation(eObject);
        }
        throw new DocumentationUnsupportedException(Messages.DocumentationManager_UnsupportedModelType);
    }

    @Override
    public Command getChangeDocumentationCommand(EObject eObject, String newDocumentation) {
        IDocumentationManager documentationManager = this.getDocumentationManager(eObject.eClass().getEPackage().getNsURI());
        if (documentationManager != null) {
            return documentationManager.getChangeDocumentationCommand(eObject, newDocumentation);
        }
        return null;
    }

    @Override
    public Command getAddAssociatedResourceCommand(EObject eObject, URI resourceURI) {
        IDocumentationManager documentationManager = this.getDocumentationManager(eObject.eClass().getEPackage().getNsURI());
        if (documentationManager != null) {
            return documentationManager.getAddAssociatedResourceCommand(eObject, resourceURI);
        }
        return null;
    }

    @Override
    public Command getRemoveAssociatedResourceCommand(EObject eObject, URI resourceURI) {
        IDocumentationManager documentationManager = this.getDocumentationManager(eObject.eClass().getEPackage().getNsURI());
        if (documentationManager != null) {
            return documentationManager.getRemoveAssociatedResourceCommand(eObject, resourceURI);
        }
        return null;
    }

    @Override
    public List<URI> getAssociatedResources(EObject eObject) throws DocumentationUnsupportedException {
        IDocumentationManager documentationManager = this.getDocumentationManager(eObject.eClass().getEPackage().getNsURI());
        if (documentationManager != null) {
            return documentationManager.getAssociatedResources(eObject);
        }
        throw new DocumentationUnsupportedException(Messages.DocumentationManager_UnsupportedModelType);
    }

    @Override
    public void registerDocumentationChangedListener(IDocumentationChangedListener listener) {
        documentationChangedListeners.add(listener);
    }

    @Override
    public void unregisterDocumentationChangedListener(IDocumentationChangedListener listener) {
        documentationChangedListeners.remove(listener);
    }

    @Override
    public Set<IDocumentationChangedListener> getRegisteredDocumentationChangedListeners() {
        return documentationChangedListeners;
    }

    @Override
    public void documentationChanged(EObject eObject) {
        for (IDocumentationChangedListener listener : documentationChangedListeners) {
            listener.documentationChanged(eObject);
        }
    }

    private static class DocumentationManagerHolder {
        public static final DocumentationManager instance = new DocumentationManager();

        private DocumentationManagerHolder() {
        }
    }
}

