/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.documentation.IDocumentationChangedListener;
import org.eclipse.papyrus.documentation.IDocumentationManager;
import org.eclipse.papyrus.documentation.eannotation.EAnnotationDocumentationManager;

public abstract class DocumentationManagerRegistry
implements IDocumentationChangedListener {
    private static final String MODELDOCUMENTATION_EXTENSION_ID = "org.eclipse.papyrus.documentation.documentationManager";
    private static final String MODELNSURI_ID = "modelNsURI";
    private static final String PRIORITY_ID = "priority";
    private static final String MODELDOCUMENTATIONCLASS_ID = "managerClass";
    private static final Integer DEFAULT_PRIORITY = 0;
    private Map<String, PriorityQueue<IDocumentationManager>> nsURIDocumentationManagerMap = new HashMap<String, PriorityQueue<IDocumentationManager>>();
    private Map<IDocumentationManager, Integer> documentationManagerPriorityMap = new HashMap<IDocumentationManager, Integer>();
    private IDocumentationManager eAnnotationDocumentationManager = EAnnotationDocumentationManager.getInstance();

    public DocumentationManagerRegistry() {
        this.eAnnotationDocumentationManager.registerDocumentationChangedListener(this);
        this.initializeMap();
    }

    protected IDocumentationManager getDocumentationManager(String nsURI) {
        IDocumentationManager documentationManager = null;
        PriorityQueue<IDocumentationManager> documentationManagers = this.nsURIDocumentationManagerMap.get(nsURI);
        if (documentationManagers != null) {
            documentationManager = documentationManagers.peek();
        }
        if (documentationManager == null) {
            return this.eAnnotationDocumentationManager;
        }
        return documentationManager;
    }

    private void initializeMap() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(MODELDOCUMENTATION_EXTENSION_ID);
        int i = 0;
        while (i < configElements.length) {
            this.initializeOne(configElements[i]);
            ++i;
        }
    }

    private void initializeOne(IConfigurationElement iConfigurationElement) {
        try {
            String modelNsURI = iConfigurationElement.getAttribute(MODELNSURI_ID);
            IDocumentationManager documentationManager = (IDocumentationManager)DocumentationManagerRegistry.createExtension(iConfigurationElement, MODELDOCUMENTATIONCLASS_ID);
            documentationManager.registerDocumentationChangedListener(this);
            String priority = iConfigurationElement.getAttribute(PRIORITY_ID);
            this.documentationManagerPriorityMap.put(documentationManager, DocumentationManagerRegistry.convertPriorityToInteger(priority));
            PriorityQueue<IDocumentationManager> documentationManagers = this.nsURIDocumentationManagerMap.get(modelNsURI);
            if (documentationManagers == null) {
                documentationManagers = new PriorityQueue<IDocumentationManager>(10, new Comparator<IDocumentationManager>(){

                    @Override
                    public int compare(IDocumentationManager o1, IDocumentationManager o2) {
                        Integer p2;
                        Integer p1 = (Integer)DocumentationManagerRegistry.this.documentationManagerPriorityMap.get(o1);
                        if (p1 == null) {
                            p1 = DEFAULT_PRIORITY;
                        }
                        if ((p2 = (Integer)DocumentationManagerRegistry.this.documentationManagerPriorityMap.get(o2)) == null) {
                            p2 = DEFAULT_PRIORITY;
                        }
                        return p2 - p1;
                    }
                });
                this.nsURIDocumentationManagerMap.put(modelNsURI, documentationManagers);
            }
            documentationManagers.add(documentationManager);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static Integer convertPriorityToInteger(String priorityString) {
        if (priorityString == null) {
            return DEFAULT_PRIORITY;
        }
        if (priorityString.equalsIgnoreCase("Lowest")) {
            return 0;
        }
        if (priorityString.equalsIgnoreCase("Low")) {
            return 1;
        }
        if (priorityString.equalsIgnoreCase("Medium")) {
            return 2;
        }
        if (priorityString.equalsIgnoreCase("High")) {
            return 3;
        }
        if (priorityString.equalsIgnoreCase("Highest")) {
            return 4;
        }
        return DEFAULT_PRIORITY;
    }

    private static Object createExtension(IConfigurationElement element, String classAttribute) throws Exception {
        return element.createExecutableExtension(classAttribute);
    }
}

