/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.eannotation;

import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.papyrus.documentation.IDocumentationChangedListener;
import org.eclipse.papyrus.documentation.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddOrRemoveAssociatedResourceCommand
extends AbstractCommand {
    private boolean remove;
    private EModelElement element;
    private Set<IDocumentationChangedListener> documentationChangedListeners;
    private String prefix;
    private String value;

    public AddOrRemoveAssociatedResourceCommand(boolean remove, EModelElement element, URI resourceURI, Set<IDocumentationChangedListener> documentationChangedListeners) {
        super(Messages.AddOrRemoveAssociatedResourceCommandLabel);
        this.remove = remove;
        this.element = element;
        this.documentationChangedListeners = documentationChangedListeners;
        if (resourceURI.isPlatform()) {
            this.prefix = "WR";
            this.value = resourceURI.toPlatformString(true);
        } else if (resourceURI.isFile()) {
            this.prefix = "ER";
            this.value = resourceURI.toFileString();
        } else {
            this.prefix = "RR";
            this.value = resourceURI.toString();
        }
    }

    private void notifyListeners() {
        for (IDocumentationChangedListener listener : this.documentationChangedListeners) {
            listener.documentationChanged((EObject)this.element);
        }
    }

    public boolean canExecute() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        if (this.remove) {
            this.removeAssociatedResource();
        } else {
            this.addAssociatedResource();
        }
    }

    public void undo() {
        if (this.remove) {
            this.addAssociatedResource();
        } else {
            this.removeAssociatedResource();
        }
    }

    private void addAssociatedResource() {
        EAnnotation annotation = this.element.getEAnnotation("http://www.topcased.org/resources");
        if (annotation == null) {
            annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource("http://www.topcased.org/resources");
            this.element.getEAnnotations().add((Object)annotation);
        }
        if (this.prefix != null && this.value != null) {
            annotation.getDetails().put((Object)this.getNewResourceKey(annotation, this.prefix, 0), (Object)this.value);
            this.notifyListeners();
        }
    }

    private void removeAssociatedResource() {
        EAnnotation annotation = this.element.getEAnnotation("http://www.topcased.org/resources");
        if (annotation != null && this.prefix != null && this.value != null) {
            EMap details = annotation.getDetails();
            for (Map.Entry detail : details) {
                if (detail.getKey() == null || !((String)detail.getKey()).startsWith(this.prefix) || !this.value.equals(detail.getValue())) continue;
                details.remove((Object)detail);
                break;
            }
            if (details.isEmpty()) {
                this.element.getEAnnotations().remove((Object)annotation);
            }
            this.notifyListeners();
        }
    }

    private String getNewResourceKey(EAnnotation annotation, String resourcePrefix, int startIndex) {
        String key = String.valueOf(resourcePrefix) + startIndex;
        if (annotation != null && annotation.getDetails().get((Object)key) == null) {
            return key;
        }
        return this.getNewResourceKey(annotation, resourcePrefix, startIndex + 1);
    }
}

