/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.eannotation;

import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.papyrus.documentation.IDocumentationChangedListener;
import org.eclipse.papyrus.documentation.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeEAnnotationCommand
extends AbstractCommand {
    private EModelElement element;
    private String newValue;
    private String oldValue;
    private String source;
    private String key;
    private Set<IDocumentationChangedListener> documentationChangedListeners;

    public ChangeEAnnotationCommand(EModelElement element, String source, String key, String newValue, Set<IDocumentationChangedListener> documentationChangedListeners) {
        super(Messages.ChangeDocCommandLabel);
        this.element = element;
        this.source = source;
        this.key = key;
        this.newValue = newValue;
        this.documentationChangedListeners = documentationChangedListeners;
    }

    public boolean canExecute() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        this.oldValue = null;
        EAnnotation annotation = this.element.getEAnnotation(this.source);
        if (annotation != null) {
            this.oldValue = (String)annotation.getDetails().get((Object)this.key);
        }
        this.redo();
    }

    public void redo() {
        this.changeDocumentation(this.element, this.newValue);
    }

    public void undo() {
        this.changeDocumentation(this.element, this.oldValue);
    }

    private void notifyListeners(String currentDoc) {
        for (IDocumentationChangedListener listener : this.documentationChangedListeners) {
            listener.documentationChanged((EObject)this.element);
        }
    }

    protected IStatus changeDocumentation(EModelElement elt, String newDoc) {
        EAnnotation annotation = elt.getEAnnotation(this.source);
        if (newDoc != null && !"".equals(newDoc)) {
            if (annotation == null) {
                annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                annotation.setSource(this.source);
                elt.getEAnnotations().add((Object)annotation);
            }
            annotation.getDetails().put((Object)this.key, (Object)newDoc);
        } else if (annotation != null) {
            annotation.getDetails().remove((Object)this.key);
            if (annotation.getDetails().isEmpty()) {
                elt.getEAnnotations().remove((Object)annotation);
            }
        }
        this.notifyListeners(newDoc);
        return Status.OK_STATUS;
    }
}

