/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.documentation.eannotation;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.documentation.DocumentationUnsupportedException;
import org.eclipse.papyrus.documentation.IDocumentationChangedListener;
import org.eclipse.papyrus.documentation.IDocumentationManager;
import org.eclipse.papyrus.documentation.Messages;
import org.eclipse.papyrus.documentation.eannotation.AddOrRemoveAssociatedResourceCommand;
import org.eclipse.papyrus.documentation.eannotation.ChangeEAnnotationCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EAnnotationDocumentationManager
implements IDocumentationManager {
    private static Set<IDocumentationChangedListener> documentationChangedListeners = new HashSet<IDocumentationChangedListener>();

    public static EAnnotationDocumentationManager getInstance() {
        return EAnnotationDocumentationManagerHolder.instance;
    }

    @Override
    public Command getChangeDocumentationCommand(EObject eObject, String newDocumentation) {
        if (EAnnotationDocumentationManager.getUnsupportedErrorMessage(eObject) == null) {
            return new ChangeEAnnotationCommand((EModelElement)eObject, "http://www.topcased.org/documentation", "documentation", newDocumentation, documentationChangedListeners);
        }
        return null;
    }

    @Override
    public String getDocumentation(EObject eObject) throws DocumentationUnsupportedException {
        String errorMsg = EAnnotationDocumentationManager.getUnsupportedErrorMessage(eObject);
        if (errorMsg == null) {
            EAnnotation annotation = ((EModelElement)eObject).getEAnnotation("http://www.topcased.org/documentation");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"documentation");
            }
            return null;
        }
        throw new DocumentationUnsupportedException(errorMsg);
    }

    @Override
    public Command getAddAssociatedResourceCommand(EObject eObject, URI resourceURI) {
        if (EAnnotationDocumentationManager.getUnsupportedErrorMessage(eObject) == null) {
            return new AddOrRemoveAssociatedResourceCommand(false, (EModelElement)eObject, resourceURI, documentationChangedListeners);
        }
        return null;
    }

    @Override
    public Command getRemoveAssociatedResourceCommand(EObject eObject, URI resourceURI) {
        if (EAnnotationDocumentationManager.getUnsupportedErrorMessage(eObject) == null) {
            return new AddOrRemoveAssociatedResourceCommand(true, (EModelElement)eObject, resourceURI, documentationChangedListeners);
        }
        return null;
    }

    @Override
    public List<URI> getAssociatedResources(EObject eObject) throws DocumentationUnsupportedException {
        String errorMsg = EAnnotationDocumentationManager.getUnsupportedErrorMessage(eObject);
        if (errorMsg == null) {
            EAnnotation annotation = ((EModelElement)eObject).getEAnnotation("http://www.topcased.org/resources");
            if (annotation != null) {
                return EAnnotationDocumentationManager.convertDetailsToURIs((EMap<String, String>)annotation.getDetails());
            }
            return new LinkedList<URI>();
        }
        throw new DocumentationUnsupportedException(errorMsg);
    }

    @Override
    public void registerDocumentationChangedListener(IDocumentationChangedListener listener) {
        documentationChangedListeners.add(listener);
    }

    @Override
    public void unregisterDocumentationChangedListener(IDocumentationChangedListener listener) {
        documentationChangedListeners.remove(listener);
    }

    @Override
    public Set<IDocumentationChangedListener> getRegisteredDocumentationChangedListeners() {
        return documentationChangedListeners;
    }

    private static List<URI> convertDetailsToURIs(EMap<String, String> details) {
        LinkedList<URI> uris = new LinkedList<URI>();
        for (Map.Entry detail : details) {
            String value = (String)detail.getValue();
            String prefix = ((String)detail.getKey()).substring(0, 2);
            URI uri = null;
            if ("RR".equals(prefix)) {
                uri = URI.createURI((String)value, (boolean)false);
            } else if ("ER".equals(prefix)) {
                uri = URI.createFileURI((String)value);
            } else if ("WR".equals(prefix)) {
                uri = URI.createPlatformResourceURI((String)value, (boolean)true);
            }
            uris.add(uri);
        }
        return uris;
    }

    private static String getUnsupportedErrorMessage(EObject eObject) {
        if (eObject instanceof EAnnotation && ((EAnnotation)eObject).getSource().equals("http://www.topcased.org/documentation")) {
            return Messages.EAnnotationDocumentationManager_DocOnDocEAnnotationError;
        }
        if (eObject instanceof EModelElement) {
            return null;
        }
        return Messages.EAnnotationDocumentationManager_NonEModelElementError;
    }

    private static class EAnnotationDocumentationManagerHolder {
        public static final EAnnotationDocumentationManager instance = new EAnnotationDocumentationManager();

        private EAnnotationDocumentationManagerHolder() {
        }
    }
}

