/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.export.actions;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.papyrus.export.actions.Messages;
import org.eclipse.papyrus.export.internal.Activator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class ExportComposite
extends Composite {
    private Text outputPathTxt;
    private Button outputDirectoryBtn;
    private Combo outputFormatCb;
    private Button btnCheckButton;
    protected IResource outputDirectory;
    protected String exporter;
    protected boolean qualifiedName;
    private IFile selectedDiagramFile;

    public ExportComposite(Composite parent, int style) {
        super(parent, style);
        this.createDialogComposite();
        this.createDialogContents();
        this.hookListeners();
    }

    protected void createDialogContents() {
        Composite composite = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setFont(this.getFont());
        composite.setLayoutData((Object)new GridData(1808));
        Label editorConfLbl = new Label(composite, 0);
        editorConfLbl.setText(Messages.ExportAllDiagramsDialog_0);
        this.outputPathTxt = new Text(composite, 2048);
        this.outputPathTxt.setEnabled(false);
        this.outputPathTxt.setLayoutData((Object)new GridData(768));
        this.outputDirectoryBtn = new Button(composite, 0);
        this.outputDirectoryBtn.setText(Messages.ExportAllDiagramsDialog_1);
        Label outputFormatLbl = new Label(composite, 0);
        outputFormatLbl.setText(Messages.ExportAllDiagramsDialog_2);
        this.outputFormatCb = new Combo(composite, 0);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 2;
        this.outputFormatCb.setLayoutData((Object)gridData2);
        this.btnCheckButton = new Button((Composite)this, 32);
        this.btnCheckButton.setText(Messages.ExportAllDiagramsDialog_btnCheckButton_text);
    }

    private void createDialogComposite() {
        GridLayout dialogLayout = new GridLayout();
        GridData dialogLayoutData = new GridData(1808);
        this.setLayout((Layout)dialogLayout);
        this.setLayoutData(dialogLayoutData);
    }

    private void hookListeners() {
        this.btnCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportComposite.this.qualifiedName = ExportComposite.this.btnCheckButton.getSelection();
            }
        });
        this.outputDirectoryBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] results;
                ContainerSelectionDialog csDialog = new ContainerSelectionDialog(Activator.getActiveWorkbenchShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, Messages.ExportAllDiagramsDialog_3);
                if (csDialog.open() == 0 && (results = csDialog.getResult()).length == 1 && results[0] instanceof IPath) {
                    URI uri = URI.createPlatformResourceURI((String)((IPath)results[0]).toString(), (boolean)true);
                    ExportComposite.this.outputDirectory = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(uri.toPlatformString(true)));
                    ExportComposite.this.outputPathTxt.setText(ExportComposite.this.outputDirectory.getLocation().toString());
                }
            }
        });
        this.outputFormatCb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportComposite.this.exporter = ExportComposite.this.outputFormatCb.getText();
            }
        });
    }

    public void setSelectedDiagramFile(IFile file) {
        this.selectedDiagramFile = file;
        this.loadData();
    }

    private void loadData() {
        this.outputDirectory = this.selectedDiagramFile.getParent();
        this.outputPathTxt.setText(this.outputDirectory.getLocation().toString());
        ImageFileFormat[] imageFileFormatArray = ImageFileFormat.VALUES;
        int n = ImageFileFormat.VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFileFormat imageFileFormat = imageFileFormatArray[n2];
            this.outputFormatCb.add(imageFileFormat.toString());
            ++n2;
        }
        this.outputFormatCb.setText(ImageFileFormat.getDefaultImageFormat().toString());
        this.exporter = this.outputFormatCb.getText();
    }

    public IResource getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getExporter() {
        return this.exporter;
    }

    public boolean getQualifiedName() {
        return this.qualifiedName;
    }
}

