/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.export.wizard;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.export.ExportAllDiagrams;
import org.eclipse.papyrus.export.wizard.ExportDiagramsErrorPage;
import org.eclipse.papyrus.export.wizard.ExportDiagramsPage;
import org.eclipse.papyrus.export.wizard.Messages;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportAllWizard
extends Wizard
implements IExportWizard {
    private ExportDiagramsPage page;
    private ExportDiagramsErrorPage pageError;
    private IFile file;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.file = this.convertSelection2File((ISelection)selection);
        if (this.file != null) {
            this.page = new ExportDiagramsPage(this.file);
            this.addPage((IWizardPage)this.page);
        } else {
            this.pageError = new ExportDiagramsErrorPage();
            this.addPage((IWizardPage)this.pageError);
        }
    }

    public boolean canFinish() {
        if (this.file == null) {
            return false;
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        if (this.file == null) {
            return false;
        }
        if (!this.page.getExport().getOutputDirectory().isAccessible()) {
            this.page.setErrorMessage(Messages.ExportAllWizard_0);
            return false;
        }
        this.page.setErrorMessage(null);
        new ExportAllDiagrams(this.file, this.page.getExport().getOutputDirectory().getLocation().toString(), this.page.getExport().getExporter(), this.page.getExport().getQualifiedName()).exportDiagramsToImages();
        return true;
    }

    private IFile convertSelection2File(ISelection sel) {
        IStructuredSelection ssel;
        if (sel instanceof IStructuredSelection && !(ssel = (IStructuredSelection)sel).isEmpty() && ssel.size() == 1) {
            Object selectedObj = ssel.getFirstElement();
            return ExportAllWizard.getIFile(selectedObj);
        }
        return null;
    }

    public static IFile getIFile(Object selectedObj) {
        Collection collec;
        IFile result = null;
        if (selectedObj instanceof IFile) {
            result = (IFile)selectedObj;
        }
        if (result == null && selectedObj instanceof IAdaptable) {
            result = (IFile)((IAdaptable)selectedObj).getAdapter(IFile.class);
        }
        if (result == null) {
            result = (IFile)Platform.getAdapterManager().getAdapter(selectedObj, IFile.class);
        }
        if (result == null && (collec = (Collection)Platform.getAdapterManager().getAdapter(selectedObj, Collection.class)) != null) {
            for (Object o : collec) {
                IFile f;
                if (!(o instanceof IFile) || !"di".equals((f = (IFile)o).getFileExtension())) continue;
                result = f;
                break;
            }
        }
        return result != null && "di".equals(result.getFileExtension()) ? result : null;
    }
}

