/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extendedtypes.uml.providers;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.emf.type.core.EditHelperContext;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.AbstractEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.extendedtypes.ActionConfiguration;
import org.eclipse.papyrus.extendedtypes.providers.GetAllExtendedElementTypeActionProvidersOperation;
import org.eclipse.papyrus.extendedtypes.providers.GetExtendedElementTypeActionProviderOperation;
import org.eclipse.papyrus.extendedtypes.providers.IExtendedElementTypeActionProvider;
import org.eclipse.papyrus.extendedtypes.uml.Activator;
import org.eclipse.papyrus.extendedtypes.uml.applystereotypeactionconfiguration.ApplyStereotypeActionConfiguration;
import org.eclipse.papyrus.extendedtypes.uml.applystereotypeactionconfiguration.StereotypeToApply;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyStereotypeActionProvider
extends AbstractProvider
implements IExtendedElementTypeActionProvider {
    public boolean provides(IOperation operation) {
        if (operation instanceof GetAllExtendedElementTypeActionProvidersOperation) {
            return true;
        }
        if (operation instanceof GetExtendedElementTypeActionProviderOperation) {
            return ((GetExtendedElementTypeActionProviderOperation)operation).getActionConfiguration() instanceof ApplyStereotypeActionConfiguration;
        }
        return false;
    }

    public ICommand getICommand(List<? extends Object> elementsToEdit, ActionConfiguration configuration) {
        if (!(configuration instanceof ApplyStereotypeActionConfiguration)) {
            Activator.INSTANCE.log("Trying to configure a stereotype action configuration with a configuration which is not a stereotype one: " + configuration);
            return UnexecutableCommand.INSTANCE;
        }
        CompositeCommand compositeCommand = new CompositeCommand("Apply Stereotypes");
        ApplyStereotypeActionConfiguration stereotypeActionConfiguration = (ApplyStereotypeActionConfiguration)configuration;
        for (Object object : elementsToEdit) {
            if (object instanceof Element) {
                for (StereotypeToApply stereotypeToApply : stereotypeActionConfiguration.getStereotypesToApply()) {
                    String qualifiedName = stereotypeToApply.getStereotypeQualifiedName();
                    ApplyStereotypeCommand command = new ApplyStereotypeCommand((Element)object, (IEditCommandRequest)new ApplyStereotypeRequest(TransactionUtil.getEditingDomain((Object)object), (Element)object, qualifiedName));
                    compositeCommand.add((IUndoableOperation)command);
                }
                continue;
            }
            Activator.INSTANCE.log("Impossible to cast the element to edit into an Element, trying to apply a stereotype on it");
        }
        return compositeCommand;
    }

    public ICommand getBeforeCreateValidationCommand(List<? extends Object> elementsToEdit, ActionConfiguration configuration) {
        ApplyStereotypeActionConfiguration stereotypeActionConfiguration = (ApplyStereotypeActionConfiguration)configuration;
        for (Object object : elementsToEdit) {
            for (StereotypeToApply stereotypeToApply : stereotypeActionConfiguration.getStereotypesToApply()) {
                if (!(object instanceof Element)) continue;
                Element elementToEdit = (Element)object;
                Package ownerPackage = elementToEdit.getNearestPackage();
                if (ownerPackage == null) {
                    return UnexecutableCommand.INSTANCE;
                }
                for (String requiredProfileName : stereotypeToApply.getRequiredProfiles()) {
                    Profile profile = ownerPackage.getAppliedProfile(requiredProfileName, true);
                    if (profile != null) continue;
                    return UnexecutableCommand.INSTANCE;
                }
            }
        }
        return null;
    }

    public void setConfiguration(IConfigurationElement element) {
    }

    public class ApplyStereotypeCommand
    extends EditElementCommand {
        protected ApplyStereotypeCommand(Element elementToEdit, IEditCommandRequest request) {
            super("Apply Stereotype Command", (EObject)elementToEdit, request);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            Stereotype stereotypeToApply = this.getElementToEdit().getApplicableStereotype(this.getRequest().getStereotypeQualifiedName());
            if (stereotypeToApply == null) {
                return CommandResult.newErrorCommandResult((String)("Impossible to find the stereotype " + this.getRequest().getStereotypeQualifiedName() + " for the element " + this.getElementToEdit()));
            }
            EObject result = this.getElementToEdit().applyStereotype(stereotypeToApply);
            if (result != null) {
                return CommandResult.newOKCommandResult();
            }
            return CommandResult.newErrorCommandResult((String)("Impossible to apply the stereotype " + stereotypeToApply + " for the element " + this.getElementToEdit()));
        }

        public boolean canExecute() {
            Stereotype stereotypeToApply = this.getElementToEdit().getApplicableStereotype(this.getRequest().getStereotypeQualifiedName());
            if (stereotypeToApply == null) {
                return false;
            }
            return super.canExecute();
        }

        protected Element getElementToEdit() {
            return (Element)super.getElementToEdit();
        }

        protected ApplyStereotypeRequest getRequest() {
            return (ApplyStereotypeRequest)super.getRequest();
        }
    }

    public class ApplyStereotypeRequest
    extends AbstractEditCommandRequest {
        private final Element elementToEdit;
        private final String stereotypeQualifiedName;

        protected ApplyStereotypeRequest(TransactionalEditingDomain editingDomain, Element elementToEdit, String stereotypeQualifiedName) {
            super(editingDomain);
            this.elementToEdit = elementToEdit;
            this.stereotypeQualifiedName = stereotypeQualifiedName;
        }

        public Object getEditHelperContext() {
            IClientContext context = this.getClientContext();
            if (context == null) {
                return this.getElementToEdit();
            }
            return new EditHelperContext((EObject)this.getElementToEdit(), context);
        }

        public Element getElementToEdit() {
            return this.elementToEdit;
        }

        public String getStereotypeQualifiedName() {
            return this.stereotypeQualifiedName;
        }
    }
}

