/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extendedtypes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.extendedtypes.Activator;
import org.eclipse.papyrus.extendedtypes.ExtendedElementTypeConfiguration;
import org.eclipse.papyrus.extendedtypes.ExtendedElementTypeSet;
import org.eclipse.papyrus.extendedtypes.ExtendedSemanticTypeDescriptor;
import org.eclipse.papyrus.extendedtypes.preferences.ExtendedTypesPreferences;
import org.eclipse.papyrus.extendedtypes.types.ExtendedHintedTypeFactory;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedTypesRegistry {
    private static ExtendedTypesRegistry registry;
    protected List<ExtendedElementTypeSet> extendedTypeSets = null;
    protected ResourceSet extendedTypesResourceSet = null;

    private ExtendedTypesRegistry() {
    }

    public static synchronized ExtendedTypesRegistry getInstance() {
        if (registry == null) {
            registry = new ExtendedTypesRegistry();
            registry.init();
        }
        return registry;
    }

    protected void init() {
        this.extendedTypesResourceSet = null;
        this.extendedTypeSets = null;
        this.extendedTypesResourceSet = this.createResourceSet();
        this.extendedTypeSets = this.loadExtendedTypeSets();
    }

    protected List<ExtendedElementTypeSet> loadExtendedTypeSets() {
        ArrayList<ExtendedElementTypeSet> extendedElementTypeSets = new ArrayList<ExtendedElementTypeSet>();
        List<ExtendedElementTypeSet> registeredSets = this.loadExtendedTypeSetsFromPlatform();
        if (registeredSets != null && !registeredSets.isEmpty()) {
            extendedElementTypeSets.addAll(registeredSets);
        }
        return extendedElementTypeSets;
    }

    protected ResourceSet createResourceSet() {
        ResourceSetImpl set = new ResourceSetImpl();
        return set;
    }

    protected List<ExtendedElementTypeSet> loadExtendedTypeSetsFromPlatform() {
        IConfigurationElement[] elements;
        ArrayList<ExtendedElementTypeSet> platformElementTypeSets = new ArrayList<ExtendedElementTypeSet>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.extendedtypes.extendedTypesSetConfiguration");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ExtendedElementTypeSet set;
            IConfigurationElement element = iConfigurationElementArray[n2];
            String modelPath = element.getAttribute("path");
            String extendedTypeSetId = element.getAttribute("id");
            String contributorID = element.getContributor().getName();
            if (Platform.inDebugMode()) {
                Activator.log.debug("[Reading extension point]");
                Activator.log.debug("-  Path to the model: " + modelPath);
                Activator.log.debug("-  id of the container bundle: " + contributorID);
                Activator.log.debug("-  id of the extended type set: " + extendedTypeSetId);
            }
            if ((set = this.getExtendedElementTypeSet(extendedTypeSetId, modelPath, contributorID)) != null) {
                platformElementTypeSets.add(set);
            }
            ++n2;
        }
        return platformElementTypeSets;
    }

    protected ExtendedElementTypeSet getExtendedElementTypeSet(String extendedTypesID, String modelPath, String bundleId) {
        Bundle bundle;
        String filePath = ExtendedTypesPreferences.getExtendedTypesRedefinition(extendedTypesID);
        if (filePath != null) {
            this.getExtendedElementTypeSetInPluginStateArea(extendedTypesID);
        }
        if (Platform.isFragment((Bundle)(bundle = Platform.getBundle((String)bundleId)))) {
            return this.getExtendedElementTypeSetInBundle(modelPath, bundleId);
        }
        Bundle[] fragments = Platform.getFragments((Bundle)bundle);
        if (fragments == null) {
            return this.getExtendedElementTypeSetInBundle(modelPath, bundleId);
        }
        Bundle[] bundleArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle fragment = bundleArray[n2];
            ExtendedElementTypeSet extendedElementTypeSet = this.getExtendedElementTypeSetInBundle(modelPath, fragment.getSymbolicName());
            if (extendedElementTypeSet != null) {
                return extendedElementTypeSet;
            }
            ++n2;
        }
        return this.getExtendedElementTypeSetInBundle(modelPath, bundleId);
    }

    protected ExtendedElementTypeSet getExtendedElementTypeSetInPluginStateArea(String path) {
        IPath resourcePath = Activator.getDefault().getStateLocation().append(path);
        URI uri = URI.createFileURI((String)resourcePath.toOSString());
        if (uri != null && uri.isFile()) {
            Resource resource = this.extendedTypesResourceSet.createResource(uri);
            try {
                resource.load(null);
            }
            catch (IOException e) {
                return null;
            }
            EObject content = (EObject)resource.getContents().get(0);
            if (content instanceof ExtendedElementTypeSet) {
                return (ExtendedElementTypeSet)content;
            }
            Activator.log.error("Impossible to cast the object into an ExtendedElementTypeSet: " + content, null);
            return null;
        }
        return null;
    }

    protected ExtendedElementTypeSet getExtendedElementTypeSetInBundle(String modelPath, String bundleID) {
        Resource resource = this.extendedTypesResourceSet.createResource(URI.createPlatformPluginURI((String)(String.valueOf(bundleID) + '/' + modelPath), (boolean)true));
        try {
            resource.load(null);
        }
        catch (IOException e) {
            return null;
        }
        EObject content = (EObject)resource.getContents().get(0);
        if (content instanceof ExtendedElementTypeSet) {
            return (ExtendedElementTypeSet)content;
        }
        Activator.log.error("Impossible to cast the object into an ExtendedElementTypeSet: " + content, null);
        return null;
    }

    public IElementType getType(String id) {
        IElementType type = ElementTypeRegistry.getInstance().getType(id);
        if (type != null) {
            return type;
        }
        for (ExtendedElementTypeSet set : this.extendedTypeSets) {
            for (ExtendedElementTypeConfiguration elementTypeConfiguration : set.getElementType()) {
                if (!id.equals(elementTypeConfiguration.getId())) continue;
                ISpecializationType createSpecializationType = ExtendedHintedTypeFactory.getInstance().createSpecializationType(new ExtendedSemanticTypeDescriptor(elementTypeConfiguration));
                ElementTypeRegistry.getInstance().register(createSpecializationType);
                return createSpecializationType;
            }
        }
        return null;
    }
}

