/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extendedtypes.advices;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.papyrus.core.queries.configuration.QueryConfiguration;
import org.eclipse.papyrus.core.queries.modisco.QueryUtil;
import org.eclipse.papyrus.extendedtypes.Activator;
import org.eclipse.papyrus.extendedtypes.ExtendedElementTypeConfiguration;
import org.eclipse.papyrus.extendedtypes.PostActionConfiguration;
import org.eclipse.papyrus.extendedtypes.providers.ExtendedElementTypeActionService;
import org.eclipse.papyrus.extendedtypes.providers.ProviderNotFoundException;
import org.eclipse.papyrus.extendedtypes.types.IExtendedHintedElementType;

public class ExtendedTypesOwnerAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeCreateCommand(CreateElementRequest request) {
        IElementType typeToCreate = request.getElementType();
        if (typeToCreate instanceof IExtendedHintedElementType) {
            ExtendedElementTypeConfiguration configuration = ((IExtendedHintedElementType)typeToCreate).getConfiguration();
            EList<QueryConfiguration> queryConfigurations = configuration.getPreValidation();
            if (queryConfigurations == null || queryConfigurations.isEmpty()) {
                return super.getBeforeCreateCommand(request);
            }
            for (Object objectToEdit : request.getElementsToEdit()) {
                for (QueryConfiguration queryConfiguration : queryConfigurations) {
                    try {
                        boolean result = QueryUtil.evaluateBooleanQuery((EObject)((EObject)objectToEdit), (QueryConfiguration)queryConfiguration);
                        if (result) continue;
                        return UnexecutableCommand.INSTANCE;
                    }
                    catch (Exception e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            }
            CompositeCommand compositeCommand = new CompositeCommand("PreValidationPostAction");
            for (PostActionConfiguration postActionConfiguration : configuration.getPostAction()) {
                ICommand command = null;
                try {
                    command = ExtendedElementTypeActionService.getInstance().getPreValidationCommand(request.getElementsToEdit(), postActionConfiguration);
                }
                catch (ProviderNotFoundException e) {
                    Activator.log.error((Throwable)e);
                }
                if (command == null) continue;
                compositeCommand.add((IUndoableOperation)command);
            }
            ICommand superCommand = super.getBeforeCreateCommand(request);
            if (superCommand != null) {
                compositeCommand.compose((IUndoableOperation)superCommand);
            }
            if (!compositeCommand.isEmpty()) {
                return compositeCommand;
            }
            return super.getBeforeCreateCommand(request);
        }
        return super.getBeforeCreateCommand(request);
    }
}

