/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extendedtypes.preferences;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.extendedtypes.Activator;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class ExtendedTypesPreferences {
    public static final String EXTENDED_TYPES_REDEFINITIONS = "extendedTypesRedefinitions";
    public static final String EXTENDED_TYPES_REDEFINITION = "extendedTypesRedefinition";
    public static final String ID = "id";
    public static final String PATH = "path";

    protected static IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected static XMLMemento getLocalRedefinitions() {
        String sValue = ExtendedTypesPreferences.getPreferenceStore().getString(EXTENDED_TYPES_REDEFINITIONS);
        try {
            if (sValue != null && !sValue.equals("")) {
                XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)new StringReader(sValue));
                return rootMemento;
            }
            return XMLMemento.createWriteRoot((String)EXTENDED_TYPES_REDEFINITIONS);
        }
        catch (WorkbenchException e) {
            Activator.log.error("Impossible to read preferences for extended types local redefinitions", (Throwable)e);
            return null;
        }
    }

    public static IMemento registerLocalRedefinition(String extendedTypesID, String path) {
        XMLMemento rootMemento = ExtendedTypesPreferences.getLocalRedefinitions();
        IMemento memento = ExtendedTypesPreferences.getExtendedTypesRedefinitionNode(extendedTypesID);
        if (memento != null) {
            ExtendedTypesPreferences.unregisterLocalRedefinition(extendedTypesID);
        }
        IMemento newMemento = rootMemento.createChild(EXTENDED_TYPES_REDEFINITION);
        newMemento.putString(ID, extendedTypesID);
        newMemento.putString(PATH, path);
        ExtendedTypesPreferences.saveLocalRedefinitions(rootMemento);
        return newMemento;
    }

    private static IMemento getExtendedTypesRedefinitionNode(String extendedTypesID) {
        IMemento[] redefinitions;
        XMLMemento rootMemento = ExtendedTypesPreferences.getLocalRedefinitions();
        IMemento[] iMementoArray = redefinitions = rootMemento.getChildren(EXTENDED_TYPES_REDEFINITION);
        int n = redefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento redefinitionMemento = iMementoArray[n2];
            String extendedTypesNodeID = redefinitionMemento.getString(ID);
            if (extendedTypesID.equals(extendedTypesNodeID)) {
                return redefinitionMemento;
            }
            ++n2;
        }
        return null;
    }

    public static String getExtendedTypesRedefinition(String extendedTypesID) {
        IMemento memento;
        if (extendedTypesID == null) {
            Activator.log.debug("Trying to find preferences for a null extended type set identifier");
        }
        if ((memento = ExtendedTypesPreferences.getExtendedTypesRedefinitionNode(extendedTypesID)) != null) {
            return memento.getString(PATH);
        }
        return null;
    }

    public static void unregisterLocalRedefinition(String extendedTypesID) {
        XMLMemento rootMemento = ExtendedTypesPreferences.getLocalRedefinitions();
        XMLMemento newRootMemento = XMLMemento.createWriteRoot((String)EXTENDED_TYPES_REDEFINITIONS);
        IMemento[] iMementoArray = rootMemento.getChildren(EXTENDED_TYPES_REDEFINITION);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento = iMementoArray[n2];
            if (!memento.getString(ID).equals(extendedTypesID)) {
                newRootMemento.putMemento(memento);
            }
            ++n2;
        }
        ExtendedTypesPreferences.saveLocalRedefinitions(newRootMemento);
    }

    private static void saveMemento(XMLMemento xmlMemento, String key) {
        StringWriter writer = new StringWriter();
        try {
            xmlMemento.save((Writer)writer);
            if (ExtendedTypesPreferences.getPreferenceStore() != null) {
                ExtendedTypesPreferences.getPreferenceStore().setValue(key, writer.toString());
            }
        }
        catch (IOException e) {
            Activator.log.error("input/ouput exception", (Throwable)e);
        }
    }

    public static void saveLocalRedefinitions(XMLMemento rootMemento) {
        ExtendedTypesPreferences.saveMemento(rootMemento, EXTENDED_TYPES_REDEFINITIONS);
    }
}

