/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extendedtypes.types;

import org.eclipse.gmf.runtime.emf.type.core.AbstractElementTypeFactory;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.SpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.internal.impl.HintedTypeFactory;
import org.eclipse.papyrus.extendedtypes.Activator;
import org.eclipse.papyrus.extendedtypes.ExtendedElementTypeConfiguration;
import org.eclipse.papyrus.extendedtypes.ExtendedSemanticTypeDescriptor;
import org.eclipse.papyrus.extendedtypes.types.IExtendedHintedElementType;

public class ExtendedHintedTypeFactory
extends AbstractElementTypeFactory {
    public static final String HINTED_TYPE_KIND = "org.eclipse.gmf.runtime.emf.core.internal.util.IHintedType";
    public static final String SEMANTIC_HINT_PARAM_NAME = "semanticHint";
    private static ExtendedHintedTypeFactory instance;

    public static synchronized ExtendedHintedTypeFactory getInstance() {
        if (instance == null) {
            instance = new ExtendedHintedTypeFactory();
        }
        return instance;
    }

    private ExtendedHintedTypeFactory() {
    }

    public ISpecializationType createSpecializationType(ISpecializationTypeDescriptor descriptor) {
        String semanticHint = descriptor.getParamValue(SEMANTIC_HINT_PARAM_NAME);
        if (descriptor instanceof ExtendedSemanticTypeDescriptor) {
            ExtendedElementTypeConfiguration configuration = ((ExtendedSemanticTypeDescriptor)descriptor).getConfiguration();
            return new ExtendedHintedSpecializationType(descriptor, semanticHint, configuration);
        }
        Activator.log.warn("The Extended type factory should never use HintedTypeFactory from GMF");
        return new HintedTypeFactory().createSpecializationType(descriptor);
    }

    private static final class ExtendedHintedSpecializationType
    extends SpecializationType
    implements IExtendedHintedElementType {
        private final String semanticHint;
        private final ExtendedElementTypeConfiguration configuration;

        public ExtendedHintedSpecializationType(ISpecializationTypeDescriptor descriptor, String semanticHint, ExtendedElementTypeConfiguration configuration) {
            super(descriptor);
            this.semanticHint = semanticHint;
            this.configuration = configuration;
        }

        public String getSemanticHint() {
            return this.semanticHint;
        }

        public ExtendedElementTypeConfiguration getConfiguration() {
            return this.configuration;
        }
    }
}

