/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extendedtypes.util;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelType;
import org.eclipse.papyrus.core.queries.configuration.QueryConfiguration;
import org.eclipse.papyrus.extendedtypes.ExtendedElementTypeConfiguration;
import org.eclipse.papyrus.extendedtypes.PostActionConfiguration;
import org.eclipse.papyrus.extendedtypes.PreActionConfiguration;
import org.eclipse.papyrus.extendedtypes.types.IExtendedHintedElementType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementTypeUtils {
    public static boolean isSemanticallyEquivalent(IElementType referenceType, IElementType typeToCompare) {
        boolean isEquivalent = true;
        if (typeToCompare.equals(referenceType)) {
            return true;
        }
        if (referenceType instanceof IMetamodelType) {
            if (!(typeToCompare instanceof IMetamodelType)) {
                return false;
            }
            EClass referenceEclass = ((IMetamodelType)referenceType).getEClass();
            EClass eclassToCompare = ((IMetamodelType)typeToCompare).getEClass();
            isEquivalent = isEquivalent && referenceEclass.equals(eclassToCompare);
        } else if (typeToCompare instanceof IMetamodelType) {
            return false;
        }
        if (referenceType instanceof IExtendedHintedElementType && typeToCompare instanceof IExtendedHintedElementType) {
            isEquivalent = isEquivalent && ElementTypeUtils.isSemanticallyEquivalent((IExtendedHintedElementType)referenceType, (IExtendedHintedElementType)typeToCompare);
        }
        return isEquivalent;
    }

    public static boolean isSemanticallyEquivalent(IExtendedHintedElementType referenceType, IExtendedHintedElementType typeToCompare) {
        boolean isEquivalent = true;
        ExtendedElementTypeConfiguration referenceConfiguration = referenceType.getConfiguration();
        ExtendedElementTypeConfiguration configurationToCompare = typeToCompare.getConfiguration();
        EList<QueryConfiguration> referencePrevalidation = referenceConfiguration.getPreValidation();
        EList<QueryConfiguration> prevalidationToCompare = configurationToCompare.getPreValidation();
        if (referencePrevalidation != null) {
            isEquivalent = isEquivalent && ElementTypeUtils.isEquivalent(referencePrevalidation, prevalidationToCompare);
        } else if (prevalidationToCompare != null) {
            isEquivalent = false;
        }
        EList<PreActionConfiguration> referencePreaction = referenceConfiguration.getPreAction();
        EList<PreActionConfiguration> preactionToCompare = configurationToCompare.getPreAction();
        if (referencePreaction != null) {
            isEquivalent = isEquivalent && ElementTypeUtils.isEquivalent(referencePreaction, preactionToCompare);
        } else if (preactionToCompare != null) {
            isEquivalent = false;
        }
        EList<PostActionConfiguration> referencePostaction = referenceConfiguration.getPostAction();
        EList<PostActionConfiguration> postactionToCompare = configurationToCompare.getPostAction();
        if (referencePostaction != null) {
            isEquivalent = isEquivalent && ElementTypeUtils.isEquivalent(referencePostaction, postactionToCompare);
        } else if (postactionToCompare != null) {
            isEquivalent = false;
        }
        return isEquivalent;
    }

    public static boolean isEquivalent(List<? extends EObject> referenceList, List<? extends EObject> listToCompare) {
        boolean isEquivalent = true;
        if (referenceList == null) {
            return listToCompare == null;
        }
        if (listToCompare == null) {
            return false;
        }
        if (referenceList.isEmpty() && listToCompare.isEmpty()) {
            return true;
        }
        if (referenceList.size() != listToCompare.size()) {
            return false;
        }
        int i = 0;
        while (i < referenceList.size()) {
            EObject reference = referenceList.get(i);
            EObject compared = listToCompare.get(i);
            isEquivalent = isEquivalent && EcoreUtil.equals((EObject)reference, (EObject)compared);
            ++i;
        }
        return isEquivalent;
    }
}

