/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.uml2.library;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.extensionpoints.uml2.Activator;
import org.eclipse.papyrus.extensionpoints.uml2.standard.ExtensionIds;
import org.eclipse.papyrus.extensionpoints.uml2.standard.RegisteredElementExtensionPoint;

public class RegisteredLibrary
extends RegisteredElementExtensionPoint {
    private static final String TAG_LIBRARY = "library";
    private static RegisteredLibrary[] RegisteredLibraries;

    public RegisteredLibrary(IConfigurationElement configElt, int ordinal) {
        super(configElt, ordinal);
    }

    public static RegisteredLibrary[] getRegisteredLibraries() {
        if (RegisteredLibraries != null) {
            return RegisteredLibraries;
        }
        ArrayList<RegisteredLibrary> libraries = new ArrayList<RegisteredLibrary>();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(ExtensionIds.LIBRARY_EXTENSION_ID);
        int j = 0;
        while (j < configElements.length) {
            RegisteredLibrary proxy = RegisteredLibrary.parseLibraryExtension(configElements[j], libraries.size());
            if (proxy != null) {
                libraries.add(proxy);
            }
            ++j;
        }
        RegisteredLibraries = libraries.toArray(new RegisteredLibrary[libraries.size()]);
        return RegisteredLibraries;
    }

    private static RegisteredLibrary parseLibraryExtension(IConfigurationElement configElt, int ordinal) {
        if (!TAG_LIBRARY.equals(configElt.getName())) {
            return null;
        }
        try {
            return new RegisteredLibrary(configElt, ordinal);
        }
        catch (Exception e) {
            String name = configElt.getAttribute("name");
            if (name == null) {
                name = "[missing name attribute]";
            }
            String msg = "Failed to load library named " + name + " in " + configElt.getDeclaringExtension().getExtensionPointUniqueIdentifier();
            Activator.log(msg);
            return null;
        }
    }
}

