/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.uml2.library;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.extensionpoints.uml2.Activator;
import org.eclipse.papyrus.extensionpoints.uml2.library.RegisteredLibrary;
import org.eclipse.papyrus.extensionpoints.uml2.standard.ExtensionLabelProvider;
import org.eclipse.papyrus.extensionpoints.uml2.utils.Util;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisteredLibrarySelectionDialog
extends ElementListSelectionDialog {
    private EList importedLibraries;
    private List<String> importedLibrariesNames;
    private RegisteredLibrary[] regLibraries;
    private Package currentModel;

    public RegisteredLibrarySelectionDialog(Composite parent, Package umlModel) {
        super(parent.getShell(), (ILabelProvider)new ExtensionLabelProvider());
        this.currentModel = umlModel;
        this.importedLibraries = umlModel.getPackageImports();
        this.importedLibrariesNames = this.getImportedLibraryNames(this.importedLibraries);
        this.regLibraries = RegisteredLibrary.getRegisteredLibraries();
        this.regLibraries = this.removeAlreadyImportededFromSelection();
        this.setTitle("Apply Libraries from Papyrus repository :");
        this.setElements(this.regLibraries);
    }

    public void run() {
        this.open();
        this.treatSelection();
    }

    private List<String> getImportedLibraryNames(EList appliedLibraries) {
        ArrayList<String> Libraries = new ArrayList<String>();
        for (PackageImport currentImport : appliedLibraries) {
            String currentName = currentImport.getImportedPackage().getName();
            Libraries.add(currentName);
        }
        return Libraries;
    }

    private RegisteredLibrary[] removeAlreadyImportededFromSelection() {
        ArrayList<RegisteredLibrary> Libraries = new ArrayList<RegisteredLibrary>();
        int i = 0;
        while (i < this.regLibraries.length) {
            String currentName = this.regLibraries[i].name;
            if (!this.importedLibrariesNames.contains(currentName)) {
                Libraries.add(this.regLibraries[i]);
            }
            ++i;
        }
        RegisteredLibrary[] cleandList = Libraries.toArray(new RegisteredLibrary[Libraries.size()]);
        return cleandList;
    }

    private void treatSelection() {
        Object[] selection = this.getResult();
        if (selection == null) {
            return;
        }
        int i = 0;
        while (i < selection.length) {
            RegisteredLibrary currentLibrary = (RegisteredLibrary)selection[i];
            URI modelUri = currentLibrary.uri;
            this.addModelLibraryImportFromURI(this.currentModel, modelUri);
            ++i;
        }
    }

    protected boolean addModelLibraryImportFromURI(Package currentModel, URI modelUri) {
        Resource modelResource = Util.getResourceSet((EObject)currentModel).getResource(modelUri, true);
        if (modelResource.getContents().size() <= 0) {
            Activator.log("The selected uri (" + modelUri.toString() + ") does not contain any model library !");
            return false;
        }
        Element root = (Element)modelResource.getContents().get(0);
        if (root instanceof Package) {
            Package libToImport = (Package)modelResource.getContents().get(0);
            PackageImport modelLibImport = UMLFactory.eINSTANCE.createPackageImport();
            modelLibImport.setImportedPackage(libToImport);
            return currentModel.getPackageImports().add((Object)modelLibImport);
        }
        Activator.log("The selected uri (" + modelUri.toString() + ") does not contain any model library !");
        return false;
    }
}

